/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fife.io.DocumentReader;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.parser.AbstractParser;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParseResult;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
extends AbstractParser {
    private SAXParserFactory spf;
    private RSyntaxTextArea textArea;
    private DefaultParseResult result;

    public XMLParser(RSyntaxTextArea rSyntaxTextArea) {
        this.textArea = rSyntaxTextArea;
        this.result = new DefaultParseResult(this);
        try {
            this.spf = SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
        }
    }

    public ParseResult parse(RSyntaxDocument rSyntaxDocument, String string) {
        this.result.clearNotices();
        Element element = rSyntaxDocument.getDefaultRootElement();
        this.result.setParsedLines(0, element.getElementCount() - 1);
        if (this.spf == null) {
            return this.result;
        }
        try {
            SAXParser sAXParser = this.spf.newSAXParser();
            Handler handler = new Handler();
            DocumentReader documentReader = new DocumentReader(rSyntaxDocument);
            InputSource inputSource = new InputSource(documentReader);
            sAXParser.parse(inputSource, (DefaultHandler)handler);
            documentReader.close();
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.result.addNotice(new DefaultParserNotice(this, "Error parsing XML: " + exception.getMessage(), 0, -1, -1));
        }
        return this.result;
    }

    private class Handler
    extends DefaultHandler {
        private Handler() {
        }

        private void doError(SAXParseException sAXParseException) {
            int n = sAXParseException.getLineNumber() - 1;
            try {
                int n2 = XMLParser.this.textArea.getLineStartOffset(n);
                int n3 = XMLParser.this.textArea.getLineEndOffset(n) - n2 + 1;
                DefaultParserNotice defaultParserNotice = new DefaultParserNotice(XMLParser.this, sAXParseException.getMessage(), n, n2, n3);
                XMLParser.this.result.addNotice(defaultParserNotice);
                System.err.println(">>> " + n2 + "-" + n3 + " -> " + defaultParserNotice);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.doError(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.doError(sAXParseException);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.doError(sAXParseException);
        }
    }
}

