/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Placeholder;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockProperty;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitDropTreeException;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.util.Path;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SplitNode {
    private SplitNode parent;
    protected double x;
    protected double y;
    protected double width;
    protected double height;
    private SplitDockAccess access;
    private Set<Path> placeholders;
    private PlaceholderMap placeholderMap;
    private long id;

    protected SplitNode(SplitDockAccess splitDockAccess, long l) {
        if (splitDockAccess == null) {
            throw new IllegalArgumentException("Access must not be null");
        }
        this.access = splitDockAccess;
        this.id = l < 0L ? splitDockAccess.uniqueID() : l;
    }

    protected void treeChanged() {
        if (this.parent != null) {
            this.parent.treeChanged();
        }
    }

    public SplitDockStation getStation() {
        return this.access.getOwner();
    }

    public Path[] getPlaceholders() {
        if (this.placeholders == null) {
            return new Path[0];
        }
        return this.placeholders.toArray(new Path[this.placeholders.size()]);
    }

    public void addPlaceholder(Path path) {
        if (this.placeholders == null) {
            this.placeholders = new HashSet<Path>();
        }
        this.placeholders.add(path);
    }

    public boolean hasPlaceholders() {
        return this.placeholders != null && !this.placeholders.isEmpty();
    }

    public boolean hasPlaceholder(Path path) {
        if (this.placeholders == null) {
            return false;
        }
        return this.placeholders.contains(path);
    }

    public void setPlaceholders(Path[] pathArray) {
        if (this.placeholders != null) {
            this.placeholders.clear();
        }
        if (pathArray != null) {
            for (Path path : pathArray) {
                this.addPlaceholder(path);
            }
        }
    }

    public boolean removePlaceholder(Path path) {
        if (this.placeholders != null) {
            return this.placeholders.remove(path);
        }
        return false;
    }

    public void removePlaceholders(Set<Path> set) {
        if (this.placeholders != null) {
            this.placeholders.removeAll(set);
        }
    }

    public void setPlaceholderMap(PlaceholderMap placeholderMap) {
        if (this.placeholderMap != null) {
            this.placeholderMap.setPlaceholderStrategy(null);
        }
        this.placeholderMap = placeholderMap;
        if (this.placeholderMap != null) {
            this.placeholderMap.setPlaceholderStrategy(this.getAccess().getOwner().getPlaceholderStrategy());
            this.getAccess().getPlaceholderSet().removeDoublePlaceholders(this, placeholderMap);
        }
    }

    public void movePlaceholderMap(SplitNode splitNode) {
        splitNode.setPlaceholderMap(null);
        splitNode.placeholderMap = this.placeholderMap;
        this.placeholderMap = null;
    }

    public PlaceholderMap getPlaceholderMap() {
        return this.placeholderMap;
    }

    public abstract boolean isOfUse();

    public void replace(SplitNode splitNode) {
        if (splitNode == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        SplitNode splitNode2 = this.getParent();
        if (splitNode2 != null) {
            int n = splitNode2.getChildLocation(this);
            splitNode2.setChild(splitNode, n);
        }
    }

    public void delete(boolean bl) {
        SplitNode splitNode;
        PlaceholderMap placeholderMap = this.getPlaceholderMap();
        if (placeholderMap != null) {
            placeholderMap.setPlaceholderStrategy(null);
        }
        if ((splitNode = this.getParent()) != null) {
            if (bl) {
                if (splitNode instanceof Root) {
                    ((Root)splitNode).setChild(null);
                } else if (!splitNode.hasPlaceholders()) {
                    Node node = (Node)splitNode;
                    SplitNode splitNode2 = node.getLeft() == this ? node.getRight() : node.getLeft();
                    splitNode = node.getParent();
                    if (splitNode != null) {
                        int n = splitNode.getChildLocation(node);
                        splitNode.setChild(splitNode2, n);
                    }
                }
            } else {
                int n = splitNode.getChildLocation(this);
                splitNode.setChild(null, n);
            }
        }
    }

    public Leaf createLeaf(long l) {
        return new Leaf(this.access, l);
    }

    public Node createNode(long l) {
        return new Node(this.access, l);
    }

    public Placeholder createPlaceholder(long l) {
        return new Placeholder(this.access, l);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setParent(SplitNode splitNode) {
        if (this.parent != null) {
            SplitNode splitNode2 = this.parent;
            this.parent = null;
            splitNode2.setChild(null, splitNode2.getChildLocation(this));
        }
        this.parent = splitNode;
    }

    public SplitNode getParent() {
        return this.parent;
    }

    public long getId() {
        return this.id;
    }

    protected SplitDockAccess getAccess() {
        return this.access;
    }

    public abstract boolean isVisible();

    public abstract SplitNode getVisible();

    public abstract Dimension getMinimumSize();

    public void updateBounds(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }

    public Root getRoot() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getRoot();
    }

    public abstract PutInfo getPut(int var1, int var2, double var3, double var5, Dockable var7);

    public abstract boolean isInOverrideZone(int var1, int var2, double var3, double var5);

    public abstract Leaf getLeaf(Dockable var1);

    public abstract Node getDividerNode(int var1, int var2);

    public abstract int getChildLocation(SplitNode var1);

    public abstract void setChild(SplitNode var1, int var2);

    public abstract void visit(SplitNodeVisitor var1);

    public abstract void evolve(SplitDockTree.Key var1, boolean var2, Map<Leaf, Dockable> var3);

    public abstract boolean insert(SplitDockPathProperty var1, int var2, Dockable var3);

    public abstract boolean insert(SplitDockPlaceholderProperty var1, Dockable var2);

    public abstract <N> N submit(SplitTreeFactory<N> var1);

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(0, stringBuilder);
        return stringBuilder.toString();
    }

    public abstract void toString(int var1, StringBuilder var2);

    public Dimension getSize() {
        Root root = this.getRoot();
        double d = root.getWidthFactor();
        double d2 = root.getHeightFactor();
        return new Dimension((int)(this.width * d + 0.5), (int)(this.height * d2 + 0.5));
    }

    public Rectangle getBounds() {
        Root root = this.getRoot();
        double d = root.getWidthFactor();
        double d2 = root.getHeightFactor();
        Rectangle rectangle = new Rectangle((int)(this.x * d + 0.5), (int)(this.y * d2 + 0.5), (int)(this.width * d + 0.5), (int)(this.height * d2 + 0.5));
        JComponent jComponent = this.getAccess().getOwner().getBasePane();
        Insets insets = jComponent.getInsets();
        int n = 0;
        int n2 = 0;
        int n3 = jComponent.getWidth();
        int n4 = jComponent.getHeight();
        if (insets != null) {
            n = insets.left;
            n2 = insets.top;
            n3 -= insets.left + insets.right;
            n4 -= insets.top + insets.bottom;
        }
        rectangle.x = Math.min(n3, Math.max(n, rectangle.x));
        rectangle.y = Math.min(n4, Math.max(n2, rectangle.y));
        rectangle.width = Math.min(n3 - rectangle.x + n, Math.max(0, rectangle.width));
        rectangle.height = Math.min(n4 - rectangle.y + n2, Math.max(0, rectangle.height));
        return rectangle;
    }

    protected Leaf create(Dockable dockable, long l) {
        MultiDockAcceptance multiDockAcceptance;
        SplitDockStation splitDockStation = this.access.getOwner();
        DockController dockController = splitDockStation.getController();
        MultiDockAcceptance multiDockAcceptance2 = multiDockAcceptance = dockController == null ? null : dockController.getAcceptance();
        if (!dockable.accept(splitDockStation) || !splitDockStation.accept(dockable)) {
            return null;
        }
        if (multiDockAcceptance != null && !multiDockAcceptance.accept(splitDockStation, dockable)) {
            return null;
        }
        Leaf leaf = this.createLeaf(l);
        return leaf;
    }

    protected SplitNode create(SplitDockTree.Key key, boolean bl, Map<Leaf, Dockable> map) {
        SplitDockTree splitDockTree = key.getTree();
        if (splitDockTree.isDockable(key)) {
            Leaf leaf;
            Dockable[] dockableArray = splitDockTree.getDockables(key);
            if (dockableArray == null || dockableArray.length == 0) {
                Path[] pathArray = splitDockTree.getPlaceholders(key);
                Placeholder placeholder = this.createPlaceholder(key.getNodeId());
                placeholder.setPlaceholders(pathArray);
                return placeholder;
            }
            SplitDockStation splitDockStation = this.access.getOwner();
            DockController dockController = splitDockStation.getController();
            MultiDockAcceptance multiDockAcceptance = dockController == null ? null : dockController.getAcceptance();
            boolean bl2 = false;
            if (dockableArray.length == 1) {
                if (bl) {
                    if (!dockableArray[0].accept(splitDockStation) || !splitDockStation.accept(dockableArray[0])) {
                        throw new SplitDropTreeException(splitDockStation, "No acceptance for " + dockableArray[0]);
                    }
                    if (multiDockAcceptance != null && !multiDockAcceptance.accept(splitDockStation, dockableArray[0])) {
                        throw new SplitDropTreeException(splitDockStation, "DockAcceptance does not allow child " + dockableArray[0]);
                    }
                }
                leaf = this.createLeaf(key.getNodeId());
                map.put(leaf, dockableArray[0]);
            } else {
                if (bl) {
                    if (!dockableArray[0].accept(splitDockStation, dockableArray[1]) || !dockableArray[1].accept(splitDockStation, dockableArray[1])) {
                        throw new SplitDropTreeException(splitDockStation, "No acceptance for combination of " + dockableArray[0] + " and " + dockableArray[1]);
                    }
                    if (multiDockAcceptance != null && !multiDockAcceptance.accept(splitDockStation, dockableArray[0], dockableArray[1])) {
                        throw new SplitDropTreeException(splitDockStation, "DockAcceptance does not allow to combine " + dockableArray[0] + " and " + dockableArray[1]);
                    }
                }
                Dockable dockable = this.access.getOwner().getCombiner().combine(dockableArray[0], dockableArray[1], this.access.getOwner(), key.getTree().getPlaceholderMap(key));
                bl2 = true;
                if (dockableArray.length == 2) {
                    Dockable dockable2;
                    leaf = this.createLeaf(key.getNodeId());
                    map.put(leaf, dockable);
                    DockStation dockStation = dockable.asDockStation();
                    if (dockStation != null && (dockable2 = key.getTree().getSelected(key)) != null) {
                        dockStation.setFrontDockable(dockable2);
                    }
                } else {
                    DockStation dockStation = dockable.asDockStation();
                    if (dockStation == null) {
                        throw new SplitDropTreeException(this.access.getOwner(), "Combination of two Dockables does not create a new station");
                    }
                    leaf = this.createLeaf(key.getNodeId());
                    map.put(leaf, dockable);
                    for (int i = 2; i < dockableArray.length; ++i) {
                        Dockable dockable3 = dockableArray[i];
                        if (bl) {
                            if (!dockable3.accept(dockStation) || !dockStation.accept(dockable3)) {
                                throw new SplitDropTreeException(this.access.getOwner(), "No acceptance of " + dockable3 + " and " + dockStation);
                            }
                            if (multiDockAcceptance != null && !multiDockAcceptance.accept(dockStation, dockable3)) {
                                throw new SplitDropTreeException(splitDockStation, "DockAcceptance does not allow " + dockable3 + " as child of " + dockStation);
                            }
                        }
                        dockStation.drop(dockable3);
                    }
                    Dockable dockable4 = key.getTree().getSelected(key);
                    if (dockable4 != null) {
                        dockStation.setFrontDockable(dockable4);
                    }
                }
            }
            leaf.evolve(key, bl, map);
            if (bl2) {
                leaf.setPlaceholderMap(null);
            }
            return leaf;
        }
        Node node = this.createNode(key.getNodeId());
        node.evolve(key, bl, map);
        return node;
    }

    public double intersection(SplitDockProperty splitDockProperty) {
        double d = Math.max(this.x, splitDockProperty.getX());
        double d2 = Math.max(this.y, splitDockProperty.getY());
        double d3 = Math.min(this.x + this.width, splitDockProperty.getX() + splitDockProperty.getWidth());
        double d4 = Math.min(this.y + this.height, splitDockProperty.getY() + splitDockProperty.getHeight());
        if (d > d3 || d2 > d4) {
            return 0.0;
        }
        if (splitDockProperty.getWidth() == 0.0 || splitDockProperty.getHeight() == 0.0) {
            return 0.0;
        }
        double d5 = Math.max(splitDockProperty.getWidth() * splitDockProperty.getHeight(), this.width * this.height);
        return (d3 - d) * (d4 - d2) / d5;
    }

    public PutInfo.Put relativeSidePut(double d, double d2) {
        if (SplitNode.above(this.x, this.y, this.x + this.width, this.y + this.height, d, d2)) {
            if (SplitNode.above(this.x, this.y + this.height, this.x + this.width, this.y, d, d2)) {
                return PutInfo.Put.TOP;
            }
            return PutInfo.Put.RIGHT;
        }
        if (SplitNode.above(this.x, this.y + this.height, this.x + this.width, this.y, d, d2)) {
            return PutInfo.Put.LEFT;
        }
        return PutInfo.Put.BOTTOM;
    }

    public static boolean above(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d2 - d4;
        double d8 = d3 - d;
        if (d8 == 0.0) {
            return false;
        }
        double d9 = d7 * d + d8 * d2;
        double d10 = (d9 - d7 * d5) / d8;
        return d6 < d10;
    }
}

