/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.station.split;

import bibliothek.gui.dock.facile.station.split.ConflictResolver;
import bibliothek.gui.dock.facile.station.split.DefaultConflictResolver;
import bibliothek.gui.dock.facile.station.split.DelegatingSplitLayoutManager;
import bibliothek.gui.dock.facile.station.split.ResizeElement;
import bibliothek.gui.dock.facile.station.split.ResizeLeaf;
import bibliothek.gui.dock.facile.station.split.ResizeNode;
import bibliothek.gui.dock.facile.station.split.ResizeRequest;
import bibliothek.gui.dock.facile.station.split.ResizeRoot;
import bibliothek.gui.dock.station.split.DefaultSplitLayoutManager;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitLayoutManager;
import bibliothek.gui.dock.station.split.SplitNode;
import java.awt.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LockedResizeLayoutManager<T>
extends DelegatingSplitLayoutManager {
    private ConflictResolver<T> conflictResolver = new DefaultConflictResolver();

    public LockedResizeLayoutManager() {
        this(new DefaultSplitLayoutManager());
    }

    public LockedResizeLayoutManager(SplitLayoutManager delegate) {
        super(delegate);
    }

    public void setConflictResolver(ConflictResolver<T> conflictResolver) {
        if (conflictResolver == null) {
            throw new IllegalArgumentException("conflictResolver must not be null");
        }
        this.conflictResolver = conflictResolver;
    }

    public ConflictResolver<T> getConflictResolver() {
        return this.conflictResolver;
    }

    @Override
    public void updateBounds(Root root, double x, double y, double factorW, double factorH) {
        Rectangle bounds;
        boolean resize;
        Rectangle current = root.getCurrentBounds();
        boolean bl = resize = !current.equals(bounds = root.getBounds()) || root.hasTreeChanged();
        if (resize) {
            boolean bl2 = resize = current.width > 10 && current.height > 10 && bounds.width > 10 && bounds.height > 10;
        }
        if (!resize) {
            super.updateBounds(root, x, y, factorW, factorH);
        } else {
            this.updateBoundsLocked(root, x, y, factorW, factorH);
        }
    }

    public void updateBoundsLocked(Root root, double x, double y, double factorW, double factorH) {
        ResizeElement<T> element = this.toElement(null, root);
        element.prepareResize();
        root.updateBounds(x, y, 1.0, 1.0, factorW, factorH, false);
        element.prepareRequests();
        element.adapt(0.0, 0.0);
        root.updateBounds(x, y, 1.0, 1.0, factorW, factorH, true);
    }

    public abstract ResizeRequest getRequest(T var1, Leaf var2);

    public abstract T prepareResize(Leaf var1);

    public ResizeElement<T> toElement(ResizeElement<T> parent, SplitNode node) {
        if (node instanceof Root) {
            return new ResizeRoot(this, (Root)node);
        }
        if (node instanceof Node) {
            Node real = (Node)node;
            boolean leftVisible = real.getLeft().isVisible();
            boolean rightVisible = real.getRight().isVisible();
            if (leftVisible && rightVisible) {
                return new ResizeNode<T>(this, parent, (Node)node);
            }
            if (leftVisible) {
                return this.toElement(parent, real.getLeft().getVisible());
            }
            if (rightVisible) {
                return this.toElement(parent, real.getRight().getVisible());
            }
            return null;
        }
        if (node instanceof Leaf) {
            return new ResizeLeaf<T>(this, parent, (Leaf)node);
        }
        return null;
    }
}

