% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracing.R
\name{getTrace}
\alias{getTrace}
\title{Tracing the index over an interpolated planned tour path.}
\usage{
getTrace(d, m, indexList, indexLabels)
}
\arguments{
\item{d}{data}

\item{m}{list of projection matrices for the planned tour}

\item{indexList}{list of index functions to calculate for each entry}

\item{indexLabels}{labels used in the output}
}
\value{
index values for each interpolation step
}
\description{
Tracing is used to test if the index value varies smoothly
over an interpolated tour path. The index value is calculated
for the data d in each projection in the interpolated sequence.
Note that all index functions must take the data in 2-d matrix
format and return the index value.
}
\examples{
d <- spiralData(4, 100)
m <- list(basisMatrix(1,2,4), basisMatrix(3,4,4))
indexList <- list(tourr::holes(), tourr::cmass())
indexLabels <- c("holes", "cmass")
trace <- getTrace(d, m, indexList, indexLabels)
plotTrace(trace)
}
