% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_protocol.R
\name{add_protocol}
\alias{add_protocol}
\title{Add a test protocol to an exercise testing data set}
\usage{
add_protocol(data, protocol)
}
\arguments{
\item{data}{A spiro \code{data.frame} containing the exercise testing data.}

\item{protocol}{A \code{data.frame} containing the test protocol, as created
by \code{\link{set_protocol}}, \code{\link{set_protocol_manual}} or
\code{\link{get_protocol}}.}
}
\value{
A \code{data.frame} of the class \code{spiro} with cardiopulmonary
parameters and the corresponding load data.
}
\description{
\code{add_protocol()} adds a predefined test protocol to an existing set of
data from an exercise test.
}
\examples{
# Get example data
file <- spiro_example("zan_gxt")

s <- spiro(file)
out <- add_protocol(
  s,
  set_protocol(pt_pre(60), pt_steps(300, 50, 50, 7, 30))
)
head(out)
}
\seealso{
\link{set_protocol} for protocol setting with helper functions.

\link{set_protocol_manual} for manual protocol design.

\link{get_protocol} For automated extraction of protocols from raw data.
}
