% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitfngr.R
\name{grad_share}
\alias{grad_share}
\title{Calculate function and gradient together but access separately.
Reduces computation since they share data in calculation.
Doesn't have to be function and gradient, can be any two
values calculated together but accessed separately.
Useful in optimization when function evaluation is expensive
since the chain rule means many parts of function and gradient
are the same.}
\usage{
grad_share(fn_gr)
}
\arguments{
\item{fn_gr}{A function that returns a list of two values.
Both are calculated when fn is called, but only the first
is returned. The second is returned when gr is called
but nothing is recalculated.}
}
\value{
An environment with two functions, fn and gr.
}
\description{
Calculate function and gradient together but access separately.
Reduces computation since they share data in calculation.
Doesn't have to be function and gradient, can be any two
values calculated together but accessed separately.
Useful in optimization when function evaluation is expensive
since the chain rule means many parts of function and gradient
are the same.
}
\examples{
quad_share <- function(x){list(sum(x^4), 4*x^3)}
share <- grad_share(quad_share)
share$fn(1)
share$gr(1)
share$gr(2)
share$fn(2)
share$gr(2)
}

