# define generics for methods we are going to define
# setGeneric("summary", function(object, ...) standardGeneric("summary"))
# setGeneric("unique", function(x, incomparables = FALSE, ...) standardGeneric("unique"))
# setGeneric("duplicated", function(x, incomparables = FALSE, ...) standardGeneric("duplicated"))
# setGeneric("all.equal.list", function(target, current, check.attributes = TRUE, ...) standardGeneric("all.equal.list"))
setGeneric("all_equal_list", function(target, current, check.attributes = TRUE, ...) standardGeneric("all_equal_list"))
# setGeneric("format", function(x, ...) standardGeneric("format"))
# setGeneric("logb", function(x, base = exp(1)) standardGeneric("logb"))
# setGeneric("match", function(x, table, nomatch = NA_integer_, incomparables = NULL) standardGeneric("match"))
# setGeneric("mean", function(x, ...) standardGeneric("mean"))
# setGeneric("median", function(x, na.rm = FALSE) standardGeneric("median"))
# setGeneric("quantile", function(x, ...) standardGeneric("quantile"))
# setGeneric("sort", function(x, decreasing = FALSE, ...) standardGeneric("sort"))
# setGeneric("sort.list", function(x, partial = NULL, na.last = TRUE, decreasing = FALSE, method = c("shell", "quick", "radix")) standardGeneric("sort.list"))
# setGeneric("cor", function(x, y = NULL, use = "everything", method = c("pearson", "kendall", "spearman")) standardGeneric("cor"))
# setGeneric("var", function(x, y = NULL, na.rm = FALSE, use) standardGeneric("var"))
# setGeneric("cut", function(x, ...) standardGeneric("cut"))

# if (version$language == "R") {
# setGeneric("diff", function(x, lag = 1L, differences = 1L, ...) base:::diff(x, lag, differences, ...))
# } else {
# setGeneric("diff", function(x, lag = 1L, differences = 1L, ...) standardGeneric("diff"))
# }

setGeneric("sort.list", signature="x")
setGeneric("days" , function(x) standardGeneric("days"))
setGeneric("years" , function(x) standardGeneric("years"))
setGeneric("hours" , function(x) standardGeneric("hours"))
setGeneric("minutes" , function(x) standardGeneric("minutes"))
setGeneric("seconds" , function(x) standardGeneric("seconds"))
setGeneric("yeardays", function(x) standardGeneric("yeardays"))
setGeneric("mdy", function(x) standardGeneric("mdy"))
setGeneric("hms", function(x) standardGeneric("hms"))
setGeneric("wdydy", function(x) standardGeneric("wdydy"))
setGeneric("timeConvert", function(x, to.zone, from.zone) standardGeneric("timeConvert"))
setGeneric("weekdays", function(x, abbreviate=TRUE) standardGeneric("weekdays"))
setGeneric("months", function(x, abbreviate=TRUE) standardGeneric("months"))
setGeneric("quarters", function(x, abbreviate=TRUE) standardGeneric("quarters"))
setGeneric("timeFloor", function(x) standardGeneric("timeFloor"))
setGeneric("timeCeiling", function(x) standardGeneric("timeCeiling"))
setGeneric("timeTrunc", function(x) standardGeneric("timeTrunc"))
# setGeneric("rev", function(x) standardGeneric("rev"))
setGeneric("shiftPositions", function(x, k = 1) standardGeneric("shiftPositions") )


## fns calling .Call that we can mark as safe
.time_rel_add <- function(e1, e2, holidays, timezonelist)
    .Call( "time_rel_add", e1, e2, holidays, timezonelist)
.time_to_string <- function(from, defaults, timezonelist)
    .Call("time_to_string", from, defaults, timezonelist)
.time_to_numeric <- function(from)
    .Call("time_to_numeric", from)
.time_from_numeric <- function(from, cl)
    .Call("time_from_numeric", from, cl)
.time_to_month_day_year <- function(x, timezonelist)
    .Call("time_to_month_day_year", x, timezonelist)
.time_to_hour_min_sec <- function(x, timezonelist)
    .Call("time_to_hour_min_sec", x, timezonelist)
.time_to_weekday <- function(x, timezonelist)
    .Call("time_to_weekday", x, timezonelist)
.time_to_year_day <- function(x, timezonelist)
    .Call("time_to_year_day", x, timezonelist)
.time_floor <- function(x, timezonelist)
    .Call("time_floor", x, timezonelist)
.time_ceiling <- function(x, timezonelist)
    .Call("time_ceiling", x, timezonelist)
.time_time_add <- function(e1, e2, sign, retclass)
    .Call("time_time_add", e1, e2, sign, retclass)
.time_num_op <- function(e1, e2, op)
    .Call("time_num_op", e1, e2, op)
.time_range <- function(x, na.rm)
    .Call("time_range", x, na.rm)
.time_sum <- function(x, na.rm, cum)
    .Call("time_sum", x, na.rm, cum)
.time_rel_seq <- function(start, end, len.vec, has.len, rel.strs, hol.vec, timezonelist)
    .Call("time_rel_seq", start, end, len.vec, has.len, rel.strs, hol.vec, timezonelist)
.tspan_to_string <- function(from)
    .Call("tspan_to_string", from)
.tspan_from_string <- function(x, format)
    .Call("tspan_from_string", x, format)
.num_align <- function(num.obj, align.pos, how.obj, match.tol)
    .Call("num_align", num.obj, align.pos, how.obj, match.tol)
.time_align <- function(time.obj, align.pos, how.obj, match.tol)
    .Call("time_align", time.obj, align.pos, how.obj, match.tol)
.time_from_month_day_index <- function(month, weekday, index, years)
    .Call("time_from_month_day_index", month, weekday, index, years)
.time_easter <- function(years)
    .Call("time_easter", years)
.time_from_string <- function(x, format, defaults, timezonelist)
    .Call("time_from_string", x, format, defaults, timezonelist)
.time_from_month_day_year <- function(month, day, year)
    .Call("time_from_month_day_year", month, day, year)
.time_from_hour_min_sec <- function(h, min, s, ms)
    .Call("time_from_hour_min_sec", h, min, s, ms)
.time_to_zone <- function(daytimes, zone, timezonelist)
    .Call("time_to_zone", daytimes, zone, timezonelist)


