% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals.spmod}
\alias{residuals.spmod}
\alias{resid.spmod}
\alias{rstandard.spmod}
\title{Extract fitted model residuals}
\usage{
\method{residuals}{spmod}(object, type = "raw", ...)

\method{resid}{spmod}(object, type = "raw", ...)

\method{rstandard}{spmod}(model, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}.}

\item{type}{\code{"raw"} for raw residuals, \code{"pearson"}
for Pearson residuals, or \code{"standardized"} for standardized residuals.
The default is \code{"raw"}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}

\item{model}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}.}
}
\value{
The residuals as a numeric vector.
}
\description{
Extract residuals from a fitted model object.
\code{resid} is an alias.
}
\details{
The raw residuals are taken as the response minus the fitted values
for the response: \eqn{y - X \hat{\beta}}. The Pearson residuals are the
raw residuals pre-multiplied by their square (Cholesky) root.
The standardized residuals are Pearson residuals divided by the square
root of one minus the leverage (hat) value. The standardized residuals are often used to
check model assumptions, as they have mean zero and variance approximately one.

\code{rstandard()} is an alias for \code{residuals(model, type = "standardized")}.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
residuals(spmod)
resid(spmod)
residuals(spmod, type = "pearson")
residuals(spmod, type = "standardized")
rstandard(spmod)
}
