% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influence.R
\name{influence.spmodel}
\alias{influence.spmodel}
\alias{influence.splm}
\alias{influence.spautor}
\title{Regression diagnostics}
\usage{
\method{influence}{splm}(model, ...)

\method{influence}{spautor}(model, ...)
}
\arguments{
\item{model}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
A tibble with residuals (\code{.resid}), leverage values (\code{.hat}),
cook's distance (\code{.cooksd}), and standardized residuals (\code{.std.resid}).
}
\description{
Provides basic quantities which are used in forming
a wide variety of diagnostics for checking the quality of fitted model objects.
}
\details{
This function calls \code{\link[=residuals.spmodel]{residuals.spmodel()}}, \code{\link[=hatvalues.spmodel]{hatvalues.spmodel()}},
and \code{\link[=cooks.distance.spmodel]{cooks.distance.spmodel()}} and puts the results into a tibble. It is
primarily used when calling \code{\link[=augment.spmodel]{augment.spmodel()}}.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
influence(spmod)
}
\seealso{
\code{\link[=augment.spmodel]{augment.spmodel()}} \code{\link[=cooks.distance.spmodel]{cooks.distance.spmodel()}} \code{\link[=hatvalues.spmodel]{hatvalues.spmodel()}} \code{\link[=residuals.spmodel]{residuals.spmodel()}}
}
