% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hood.R
\name{windower}
\alias{windower}
\title{support functions for spooky}
\usage{
windower(
  df,
  seq_len,
  lno = 1,
  n_windows = 5,
  ci = 0.8,
  dates = NULL,
  error_scale,
  error_benchmark
)
}
\arguments{
\item{df}{A data frame with time features on columns}

\item{seq_len}{Positive integer. Time-step number of the forecasting sequence. Default: NULL (automatic selection between 1 and the square root of full length).}

\item{lno}{Positive integer. Number of data points to leave out for resampling (using jack-knife approach). Default: NULL (automatic selection between 1 and the square root of full length).}

\item{n_windows}{Positive integer. Number of validation windows to test prediction error. Default: 10.}

\item{ci}{Confidence interval for prediction. Default: 0.8}

\item{dates}{Date. Vector with dates for time features.}

\item{error_scale}{String. Scale for the scaled error metrics. Two options: "naive" (average of naive one-step absolute error for the historical series) or "deviation" (standard error of the historical series). Default: "naive".}

\item{error_benchmark}{String. Benchmark for the relative error metrics. Two options: "naive" (sequential extension of last value) or "average" (mean value of true sequence). Default: "naive".}
}
\description{
support functions for spooky
}
\author{
Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com}
}
