% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_album_popularity.R
\name{get_album_popularity}
\alias{get_album_popularity}
\title{Get Album Popularity}
\usage{
get_album_popularity(albums, access_token = get_spotify_access_token())
}
\arguments{
\item{albums}{Dataframe containing a column `album_uri`, corresponding to Spotify Album URIs. Can be output from spotifyr::get_albums()}

\item{access_token}{Spotify Web API token. Defaults to spotifyr::get_spotify_access_token()}
}
\description{
This function returns popularity of albums on Spotify
}
\examples{
\dontrun{
artists <- get_artists('radiohead')
albums <- get_albums(artists$artist_uri[1])
get_album_popularity(albums)
}
}
\keyword{albums}
