% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_fire.R
\name{extract_fire}
\alias{extract_fire}
\title{Extracting fires from the spatiotemporal clustering results}
\usage{
extract_fire(result, cluster = "all", noise = FALSE)
}
\arguments{
\item{result}{\code{spotoroo} object.
A result of a call to \code{\link[=hotspot_cluster]{hotspot_cluster()}}.}

\item{cluster}{Character/Integer. If "all", extract all clusters.
If an integer vector is given, extract corresponding
clusters.}

\item{noise}{Logical. Whether or not to include noise.}
}
\value{
A data.frame. The fire information
\itemize{
\item \code{lon} : Longitude.
\item \code{lat} : Latitude.
\item \code{obsTime} : Observed time.
\item \code{timeID} : Time indexes.
\item \code{membership} : Membership labels.
\item \code{noise} : Whether it is a noise point.
\item \code{distToIgnition} : Distance to the ignition location.
\item \code{distToIgnitionUnit} : Unit of distance to the ignition
location.
\item \code{timeFromIgnition} : Time from ignition.
\item \code{timeFromIgnitionUnit} : Unit of time from ignition.
\item \code{type} : Type of the entry, either "hotspot", "noise" or
"ignition"
\item \code{obsInCluster} : Number of observations in the cluster.
\item \code{clusterTimeLen} : Length of time of the cluster.
\item \code{clusterTimeLenUnit} : Unit of length of time of the
cluster.
}
}
\description{
This function takes a \code{spotoroo} object to produce a data frame which
contains information about the fire.
}
\examples{
\donttest{

  # Time consuming functions (>5 seconds)


  # Get clustering results
  result <- hotspot_cluster(hotspots,
                          lon = "lon",
                          lat = "lat",
                          obsTime = "obsTime",
                          activeTime = 24,
                          adjDist = 3000,
                          minPts = 4,
                          minTime = 3,
                          ignitionCenter = "mean",
                          timeUnit = "h",
                          timeStep = 1)


  # Extract all fires
  all_fires <- extract_fire(result)
  head(all_fires, 3)

  # Extract cluster 4
  fire_4 <- extract_fire(result, 4)
  head(fire_4, 3)
}

}
