% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/css_loader.R
\name{addLoader}
\alias{addLoader}
\title{Add CSS loaders from server}
\value{
CSS load in R6 class
}
\description{
Add/remove CSS loaders from server to any Shiny/HTML component.
It is useful to indicate busy status when some code is running in the server
and when it finishes, remove the loader to indicate clear status.
}
\examples{
if (interactive()){
  ui <- fluidPage(
    h4("Use buttons to show and hide loaders with different methods"),
    spsDepend("css-loader"), # required
    tags$b("Replace"), br(),
    actionButton("b_re_start", "Replace"),
    actionButton("b_re_stop", "stop replace"),
    br(), tags$b("Inline"), br(),
    actionButton("b_in_start", "Inline"),
    actionButton("b_in_stop", "stop inline"),
    br(), tags$b("Full screen"), br(),
    actionButton("b_fs_start", "Full screen 2s"), br(),
    h4("Add loaders to a big HTML chunk"),
    actionButton("chunk_start", "Chunk loader"),
    actionButton("chunk_stop", "Stop"), br(),
    column(6,
           id = "chunk",
           style = "background-color: #eee",
           h5("Here are some text 12345"),
           tags$hr(),
           icon("home"),
           p("blablablablablablablablablablablablablablablablablablablabla"),
           p("blablablablablablablablablablablablablablablablablablablabla"),
           p("blablablablablablablablablablablablablablablablablablablabla"),
           p("blablablablablablablablablablablablablablablablablablablabla")
    )
  )

  server <- function(input, output, session) {
    # Init loaders
    loader_replace <- addLoader$new("b_re_start", type = "facebook")
    loader_inline <- addLoader$new("b_in_start", color = "green", method = "inline")
    loader_fs <- addLoader$new(
      "b_fs_start", color = "pink", method = "full_screen",
      bg_color = "#eee", height = "30rem", type = "heart"
    )
    loader_chunk <- addLoader$new(
      "chunk", type = "spinner", color = "orange",
      footer = h5("chunk loader")
    )

    # toggle loaders
    ## replace
    observeEvent(input$b_re_start, {
      loader_replace$show()
    })
    observeEvent(input$b_re_stop, {
      loader_replace$hide()
    })
    ## inline
    observeEvent(input$b_in_start, {
      loader_inline$show()
    })
    observeEvent(input$b_in_stop, {
      loader_inline$hide()
    })
    ## full screen
    observeEvent(input$b_fs_start, {
      loader_fs$show()
      Sys.sleep(2)
      loader_fs$hide()
    })
    ## chunk
    observeEvent(input$chunk_start, {
      loader_chunk$show()
    })
    observeEvent(input$chunk_stop, {
      loader_chunk$hide()
    })

  }

  shinyApp(ui, server)
}

if (interactive()){
  ui <- bootstrapPage(
    spsDepend("css-loader"), # required
    h4("Add loaders to Shiny `render` events"),
    tags$b("Replace"), br(),
    selectizeInput(inputId = "n_re",
                   label = "Change this to render the following plot",
                   choices = c(10, 20, 35, 50)),
    plotOutput(outputId = "p_re"),
    br(), tags$b("Full screen"), br(),
    selectInput(inputId = "n_fs",
                label = "Change this to render the following plot",
                choices = c(10, 20, 35, 50)),
    plotOutput(outputId = "p_fs")
  )

  server <- function(input, output, session) {
    # create loaders
    l_re <- addLoader$new("p_re")
    l_fs <- addLoader$new(
      "p_fs", color = "pink", method = "full_screen",
      bg_color = "#eee", height = "30rem", type = "grid",
      footer = h4("Replotting...")
    )
    # use loaders in rednering
    output$p_re <- renderPlot({
      on.exit(l_re$hide())
      # to make it responsive
      # (always create a new one by calculating the new height and width)
      l_re$recreate()$show()
      Sys.sleep(1)
      hist(faithful$eruptions,
           probability = TRUE,
           breaks = as.numeric(input$n_re),
           xlab = "Duration (minutes)",
           main = "Geyser eruption duration")
    })
    output$p_fs <- renderPlot({
      on.exit(l_fs$hide())
      l_fs$show()

      Sys.sleep(1)
      hist(faithful$eruptions,
           probability = TRUE,
           breaks = as.numeric(input$n_fs),
           xlab = "Duration (minutes)",
           main = "Geyser eruption duration")
    })
  }
  shinyApp(ui, server)
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{addLoader$new()}}
\item \href{#method-show}{\code{addLoader$show()}}
\item \href{#method-hide}{\code{addLoader$hide()}}
\item \href{#method-destroy}{\code{addLoader$destroy()}}
\item \href{#method-recreate}{\code{addLoader$recreate()}}
\item \href{#method-clone}{\code{addLoader$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
create a loader object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{addLoader$new(
  target_selector = "",
  isID = TRUE,
  type = "default",
  src = "",
  id = "",
  height = NULL,
  width = height,
  color = "#337ab7",
  opacity = 1,
  method = "replace",
  block = TRUE,
  center = TRUE,
  bg_color = "#eee",
  footer = NULL,
  z_index = 2000,
  alert = FALSE,
  session = shiny::getDefaultReactiveDomain()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{target_selector}}{string, which Shiny component you want to add the
loader to? a shiny component ID or a valid CSS selector if \code{isID = FLASE}.
for example, you have a button and want to add animation to it:\preformatted{actionButton(inputId = "btn")
}

This function is used in server only, so if you are in shiny module,
use \code{ns()} for ID on UI but \strong{DO NOT} add the \code{ns()} wrapper on server.

UI\preformatted{actionButton(inputId = ns("btn"))
}

server\preformatted{addLoader$new(target_selector = "btn", ...)
}}

\item{\code{isID}}{bool, is your selector an ID?}

\item{\code{type}}{string, one of  "circle", "dual-ring", "facebook", "heart",
"ring", "roller", "default", "ellipsis", "grid", "hourglass", "ripple",
"spinner", "gif", default is "default".}

\item{\code{src}}{string, online URL or local path of the gif animation file if
you would like to upload your own loader.}

\item{\code{id}}{string, the unqiue ID for the loader, if not provided, a random
ID will be given. If you are using shiny modules, DO NOT use \code{session$ns('YOUR_ID')}
to wrap it. Loaders live on the top level of the document.}

\item{\code{height}}{string, (r)em, "1.5rem", "1.5em", or pixel, like "10px".
Default is \code{NULL}, will be automatically calculated based on the target
component. It is recommend to use \code{NULL} for "replace" and "inline" method
to let it automatically be calculated, but required for "full_screen" method.}

\item{\code{width}}{string, default is the same as \code{height} to make it square.}

\item{\code{color}}{string, any valid CSS color name, or hex color code}

\item{\code{opacity}}{number, between 0-1}

\item{\code{method}}{one of "replace", "inline", "full_screen", see details}

\item{\code{block}}{bool, for some input components, once the loader starts,
it can also block user interaction with the component, very useful for
"inline" method, eg. prevent users from clicking the button while some
process is still running.}

\item{\code{center}}{bool, try to place the load to the center of the target for
"inline" and "replace" and center of the screen for "full_screen".}

\item{\code{bg_color}}{string, any valid CSS color name, or hex color code. Only
works for "full_screen" method.}

\item{\code{footer}}{Additional Shiny/HTML component to add below the loader, like
a title \code{h1("load title")}. \code{inline} method does not have a footer.}

\item{\code{z_index}}{number, only works for "full_screen" method, what CSS layer
should the overlay be places. In HTML, all elements have the default of 0.}

\item{\code{alert}}{bool, should alert if target cannot be found or other javascript
errors? mainly for debugging}

\item{\code{session}}{shiny session}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\subsection{Methods}{
\itemize{
\item \code{replace}: use a HTML \code{div} with the same CSS styles to \strong{replace the original}
\strong{target}, but add the loader inside and remove original content inside. When the
loader is \code{hide}, show the original \code{div} and hide this loader \code{div}. Height
and width is the original \code{div}'s height unless specially specified. Good
example of this will be some plot outputs.
\item \code{inline}: append the loader as the first child of target HTML container.
loader's height and width is the original \code{div}'s height unless specially specified.
In addition, this methods will \strong{disable} all inputs and buttons inside the
target container, so this method can be useful on some buttons.
\item \code{full_screen}: Do not change anything of the target HTML container, add
an overlay to \strong{cover the whole page} when \code{show} and hide the overlay when \code{hide}.
This method requires the \code{height} to be specified manually. Under this method,
\code{bg_color} and \code{z_index} can also be changed.
}
}

\subsection{New container}{

\code{addLoader$new()} method only stores the loader information, the loader is
add to your docuement upon the first time \code{addLoader$show()} is called.
}

\subsection{Required javascript and css files}{

Unfortunately, js and css required by this function cannot be added automatically from
the server end. These files have to be added before app start. Add
\code{spsDepend('css-loader')} somewhere in your UI to add the dependency.
}
}

\subsection{Returns}{
A R6 loader object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\if{latex}{\out{\hypertarget{method-show}{}}}
\subsection{Method \code{show()}}{
show the loader
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{addLoader$show(alert = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alert}}{bool, if the target selector or loader is not found,
alert on UI? For debugging purposes.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Make sure your target element is visible when the time you call this \code{show}
method, otherwise, you will not get it if height and width is rely on
auto-calculation for "replace" and "inline" method. "full_screen" method
is not affected.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hide"></a>}}
\if{latex}{\out{\hypertarget{method-hide}{}}}
\subsection{Method \code{hide()}}{
hide the loader
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{addLoader$hide(alert = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alert}}{bool, if the target selector or loader is not found,
alert on UI? For debugging purposes.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-destroy"></a>}}
\if{latex}{\out{\hypertarget{method-destroy}{}}}
\subsection{Method \code{destroy()}}{
Destroy current loader
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{addLoader$destroy(alert = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alert}}{bool, if the target selector or loader is not found,
alert on UI? For debugging purposes.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
hide and remove current loader from the current document
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-recreate"></a>}}
\if{latex}{\out{\hypertarget{method-recreate}{}}}
\subsection{Method \code{recreate()}}{
recreate the loader
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{addLoader$recreate(
  type = "default",
  src = NULL,
  id = "",
  height = NULL,
  width = height,
  color = "#337ab7",
  opacity = 1,
  method = "replace",
  block = TRUE,
  center = TRUE,
  bg_color = "#eee",
  footer = NULL,
  z_index = 2000,
  alert = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{string, one of  "circle", "dual-ring", "facebook", "heart",
"ring", "roller", "default", "ellipsis", "grid", "hourglass", "ripple",
"spinner", "gif", default is "default".}

\item{\code{src}}{string, online URL or local path of the gif animation file if
you would like to upload your own loader.}

\item{\code{id}}{string, the unqiue ID for the loader, if not provided, a random
ID will be given. If you are using shiny modules, DO NOT use \code{session$ns('YOUR_ID')}
to wrap it. Loaders live on the top level of the document.}

\item{\code{height}}{string, (r)em, "1.5rem", "1.5em", or pixel, like "10px".
Default is \code{NULL}, will be automatically calculated based on the target
component. It is recommend to use \code{NULL} for "replace" and "inline" method
to let it automatically be calculated, but required for "full_screen" method.}

\item{\code{width}}{string, default is the same as \code{height} to make it square.}

\item{\code{color}}{string, any valid CSS color name, or hex color code}

\item{\code{opacity}}{number, between 0-1}

\item{\code{method}}{one of "replace", "inline", "full_screen", see details}

\item{\code{block}}{bool, for some input components, once the loader starts,
it can also block user interaction with the component, very useful for
"inline" method, eg. prevent users from clicking the button while some
process is still running.}

\item{\code{center}}{bool, try to place the load to the center of the target for
"inline" and "replace" and center of the screen for "full_screen".}

\item{\code{bg_color}}{string, any valid CSS color name, or hex color code. Only
works for "full_screen" method.}

\item{\code{footer}}{Additional Shiny/HTML component to add below the loader, like
a title \code{h1("load title")}. \code{inline} method does not have a footer.}

\item{\code{z_index}}{number, only works for "full_screen" method, what CSS layer
should the overlay be places. In HTML, all elements have the default of 0.}

\item{\code{alert}}{bool, should alert if target cannot be found or other javascript
errors? mainly for debugging}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method will first disable then destroy (remove) current loader,
and finally store new information of the new loader.

\strong{Note:}: this method only refresh loader object on the server, the loader
is \strong{not} recreated until the next time \code{show} method is called.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{addLoader$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
