% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/albersgeod.R
\name{albersgeod}
\alias{albersgeod}
\title{Project Albers Projection in Plane to Latitude and Longitude (Spheroid)}
\usage{
albersgeod(x, y, sph = "GRS80", clon = -96, clat = 23, sp1 = 29.5,
  sp2 = 45.5)
}
\arguments{
\item{x}{Vector of Albers x-coordinates to be projected to latitude/longitude.}

\item{y}{Vector of Albers y-coordinates to be projected to latitude/longitude.}

\item{sph}{Spheroid options: Clarke1866, GRS80, WGS84.  The default is
GRS80.}

\item{clon}{Center longitude (decimal degrees).  The default is -96.}

\item{clat}{Origin latitude (decimal degrees).  The default is 23.}

\item{sp1}{Standard parallel 1 (decimal degrees).  The default is 29.5.}

\item{sp2}{Standard parallel 2 (decimal degrees).  The default is 45.5.}
}
\value{
A data frame of latitude and longitude projections for Albers
  x-coordinates and y-coordinates
}
\description{
Convert x-coordinates and y-coordinates given in Albers projection to
latitude and longitude in Clarke1866, GRS80 or WGS84 spheriod with
specified parameters.
}
\references{
J. Snyder, USGS Professional Paper 1395.
}
\author{
Tony Olsen \email{Olsen.Tony@epa.gov}
}
\keyword{survey}
