% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cont_cdfplot.R
\name{cont_cdfplot}
\alias{cont_cdfplot}
\title{Create a PDF file containing cumulative distribution functions (CDF) plots}
\usage{
cont_cdfplot(
  pdffile = "cdf2x2.pdf",
  cdfest,
  units_cdf = "Percent",
  ind_type = rep("Continuous", nind),
  log = rep("", nind),
  xlab = NULL,
  ylab = NULL,
  ylab_r = NULL,
  legloc = NULL,
  cdf_page = 4,
  width = 10,
  height = 8,
  confcut = 0,
  cex.main = 1.2,
  cex.legend = 1,
  ...
)
}
\arguments{
\item{pdffile}{Name of the PDF file.  The default is "cdf2x2.pdf".}

\item{cdfest}{Data frame with the same structure as the "CDF"
output from  \code{cont_analysis}.}

\item{units_cdf}{Indicator for the label utilized for the left side y-axis
and the values used for the left side y-axis tick marks, where "Percent"
means the label and values are in terms of percent of the population, and
"Units" means the label and values are in terms of units (count, length,
or area) of the population.  The default is "Percent".}

\item{ind_type}{Character vector consisting of the values "Continuous" or
"Ordinal" that controls the type of CDF plot for each indicator.  The
default is "Continuous" for every indicator.}

\item{log}{Character vector consisting of the values "" or "x" that
controls whether the x axis uses the original scale ("") or the base 10
logarithmic scale ("x") for each indicator.  The default is "" for every
indicator.}

\item{xlab}{Character vector consisting of the x-axis label for each
indicator. If this argument equals NULL, then indicator names are used as
the labels. The default is NULL.}

\item{ylab}{Character string providing the left side y-axis label.  If
argument units_cdf equals "Units", a value should be provided for this
argument.  Otherwise, the label will be "Percent".  The default is
"Percent".}

\item{ylab_r}{Character string providing the label for the right side y-axis
(and, hence, determining the values used for the right side y-axis tick
marks), where NULL means a right side y-axis is not created.  If this
argument equals "Same", the right side y-axis will have the same label and
tick mark values as the left side y-axis.  If this argument equals a
character string other than "Same", the right side y-axis label will be the
value provided for argument ylab_r, and the right side y-axis tick mark
values will be determined by the choice not utilized for argument
units_cdf, which means that the default value of argument units_cdf (i.e.,
"Percent") will result in the right side y-axis tick mark values being
expressed  in terms of units of the population (i.e., count, length, or
area).  The default is NULL.}

\item{legloc}{Indicator for location of the plot legend, where "BR" means
bottom right, "BL" means bottom left, "TR" means top right, "TL" means
top left, and NULL means no legend.  The default is NULL.}

\item{cdf_page}{Number of CDF plots on each page, which must be chosen from
the values: 1, 2, 4, or 6.  The default is 4.}

\item{width}{Width of the graphic region in inches.  The default is 10.}

\item{height}{Height of the graphic region in inches.  The default is 8.}

\item{confcut}{Numeric value that controls plotting confidence limits at
the CDF extremes.  Confidence limits for CDF values (percent scale) less
than confcut or greater than 100 minus confcut are not plotted.  A value of
zero means confidence limits are plotted for the complete range of the CDF.
The default is 0.}

\item{cex.main}{Expansion factor for the plot title.  The default is 1.2.}

\item{cex.legend}{Expansion factor for the legend title. The default is 1.}

\item{...}{Additional arguments passed to the \code{cdf_plot} function.}
}
\value{
A PDF file containing the CDF plots.
}
\description{
This function creates a PDF file containing CDF plots.  Input data for the
plots is provided by a data frame with the same structure as the "CDF"
output from  \code{cont_analysis}.  Plots are produced for every combination of \code{Type} of
population, \code{Subpopulation} within \code{Type}, and \code{Indicator} (every combination
of subpopulations, subpopulation levels, and variables).
}
\examples{
\dontrun{
dframe <- data.frame(
  siteID = paste0("Site", 1:100),
  wgt = runif(100, 10, 100),
  xcoord = runif(100),
  ycoord = runif(100),
  stratum = rep(c("Stratum1", "Stratum2"), 50),
  ContVar = rnorm(100, 10, 1),
  All_Sites = rep("All Sites", 100),
  Resource_Class = rep(c("Good", "Poor"), c(55, 45))
)
myvars <- c("ContVar")
mysubpops <- c("All_Sites", "Resource_Class")
mypopsize <- data.frame(
  Resource_Class = c("Good", "Poor"),
  Total = c(4000, 1500)
)
myanalysis <- cont_analysis(dframe,
  vars = myvars, subpops = mysubpops,
  siteID = "siteID", weight = "wgt", xcoord = "xcoord", ycoord = "ycoord",
  stratumID = "stratum", popsize = mypopsize
)
cont_cdfplot("myanalysis.pdf", myanalysis$CDF, ylab_r = "Stream Length (km)")
}

}
\seealso{
\describe{
  \item{\code{\link{cdf_plot}}}{for plotting a cumulative distribution
    function (CDF)}
  \item{\code{\link{cont_cdftest}}}{for CDF hypothesis testing}
  }
}
\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
\keyword{plot}
\keyword{survey}
