% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gompertz.R
\name{gompertz}
\alias{gompertz}
\alias{dgompertz}
\alias{qgompertz}
\alias{pgompertz}
\alias{rgompertz}
\title{Gompertz Distribution}
\usage{
dgompertz(x, scale = 1, shape, log = FALSE)

qgompertz(q, scale = 1, shape, lower.tail = TRUE, log.p = FALSE)

pgompertz(p, scale = 1, shape, lower.tail = TRUE, log.p = FALSE)

rgompertz(n, scale = 1, shape)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{scale}{scale parameter.}

\item{shape}{shape parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x],otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
dgompertz gives the density, pgompertz gives the distribution function,
qgompertz gives the quantile function, and rgompertz generates random deviates.
}
\description{
Density, distribution function, quantile function and random generation
for the Gompertz distribution.
The functions are wrappers on the equivalent VGAM functions that
return a zero length numeric vector if x, q or p are zero length.
}
\examples{
x <- rgompertz(1000,1,0.1)
hist(log(x),freq=FALSE,col='gray',border='white')
hist(x,freq=FALSE,col='gray',border='white')
curve(dgompertz(x,1,0.1),add=TRUE,col='red4',lwd=2)
}
\seealso{
\code{\link[VGAM]{dgompertz}}
}
