% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgumbel.R
\name{lgumbel}
\alias{lgumbel}
\alias{dlgumbel}
\alias{qlgumbel}
\alias{plgumbel}
\alias{rlgumbel}
\title{Log-Gumbel Distribution}
\usage{
dlgumbel(x, location = 0, scale = 0, log = FALSE)

qlgumbel(p, location = 0, scale = 0, lower.tail = TRUE,
  log.p = FALSE)

plgumbel(q, location = 0, scale = 0, lower.tail = TRUE,
  log.p = FALSE)

rlgumbel(n, location = 0, scale = 0)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{location}{location parameter.}

\item{scale}{scale parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{vector of probabilities.}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x],otherwise, P[X > x].}

\item{n}{number of observations.}
}
\value{
dlgumbel gives the density, plgumbel gives the distribution function,
qlgumbel gives the quantile function, and rlgumbel generates random deviates.
}
\description{
Density, distribution function, quantile function and random generation
for the Log-Gumbel distribution with \code{scale} and \code{location} parameters.
}
\examples{
x <- rlgumbel(1000,1,0.1)
hist(log(x),freq=FALSE,col='gray',border='white')
hist(x,freq=FALSE,col='gray',border='white')
curve(dlgumbel(x,1,0.1),add=TRUE,col='red4',lwd=2)
}
