% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correction_functions.R
\name{eem_interp}
\alias{eem_interp}
\title{Missing values are interpolated within EEM data}
\usage{
eem_interp(data, cores = detectCores(logical = FALSE)/2)
}
\arguments{
\item{data}{object of class eemlist with spectra containing missing values}

\item{cores}{specify number of cores for parallel computation}
}
\value{
object of class eemlist with interpoleted spectra.
}
\description{
Missing EEM data can be interpolated. Usually it is the result of removing scatter. It is done along each excitation wavelength. This step is recommended if you aim for a PARAFAC analysis. Interpolation is done with hermitean interpolation polynomials using \code{\link[pracma]{pchip}}.
}
\examples{
\donttest{
data(eem_list)

remove_scatter <- c()
remove_scatter["raman1"] = TRUE
remove_scatter["raman2"] = TRUE
remove_scatter["rayleigh1"] = TRUE
remove_scatter["rayleigh2"] = TRUE
remove_scatter_width = c(15,10,16,12)

eem_list <- eem_rem_scat(eem_list,remove_scatter,remove_scatter_width)

eem_list <- eem_interp(eem_list)
}
}
\references{
Elcoroaristizabal, S., Bro, R., García, J., Alonso, L. 2015. PARAFAC models of fluorescence data with scattering: A comparative study. Chemometrics and Intelligent Laboratory Systems, 142, 124-130
\url{https://doi.org/10.1016/j.chemolab.2015.01.017}
}
\seealso{
\code{\link[pracma]{pchip}}
}
