% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_functions.R
\name{list_join}
\alias{list_join}
\title{Full join of a list of data frames.}
\usage{
list_join(df_list, by)
}
\arguments{
\item{df_list}{list of data frames to by joined}

\item{by}{character vector containing information how to join data frames. Format to be according to by in \code{\link[dplyr]{full_join}}. Each data frame has to contain the column(s) used for joining.}
}
\value{
The joint data frame.
}
\description{
Full join of a list of data frames.
}
\examples{
a <- data.frame(what=letters[1:5],a=c(1:5))
b <- data.frame(what=letters[1:5],b=c(7:11))
c <- data.frame(what=letters[1:5],c=c(20:24))

df_list <- list(a,b,c)

list_join(df_list,by="what")
}
\seealso{
\code{\link[dplyr]{full_join}}
}
