% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coalesce.R
\name{coalesce}
\alias{coalesce}
\title{Replace NAs in parallel vectors}
\usage{
coalesce(x, y, ...)
}
\arguments{
\item{x}{a vector}

\item{y}{replacement values}

\item{...}{further replacement values}
}
\value{
x with NAs replaced with y
}
\description{
Replaces NA elements of x with corresponding element of y, and NA elements of 
that with corresponding element from dots.
}
\section{Changes}{


Rather than using eagerly evaluating the dot arguments and Reducing over them,
instead we use recursion to evaluate them lazily.
}

\examples{

x <- c(1:4, NA, 1:4, NA)
y <- c(1:9, NA)
z <- c(NA, NA, 1:8)
coalesce(x,y,z) 

}
\references{
\url{https://stackoverflow.com/a/19254510/986793}
}
\author{
\href{https://stackoverflow.com/users/903061/gregor}{Gregor Thomas},
}
