% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_sea_age.R
\name{choice_c,report_sea_age-method}
\alias{choice_c,report_sea_age-method}
\alias{choice_c.report_sea_age}
\title{command line interface for report_sea_age class}
\usage{
\S4method{choice_c}{report_sea_age}(
  object,
  dc,
  taxa = 2220,
  stage = c("5", "11", "BEC", "BER", "IND"),
  par = c("1786", "1785", "C001", "A124"),
  horodatedebut,
  horodatefin,
  limit1hm,
  limit2hm,
  silent = FALSE
)
}
\arguments{
\item{object}{An object of class \link{report_sea_age-class}}

\item{dc}{A numeric or integer, the code of the dc, coerced to integer,see \link{choice_c,ref_dc-method}}

\item{taxa}{'2220=Salmo salar',
these should match the ref.tr_taxon_tax referential table in the stacomi database, see \link{choice_c,ref_taxa-method}}

\item{stage}{'5','11','BEC','BER','IND'}

\item{par}{Parameters chosen for the report are measured body size (1786), measured fork length (1785),video size (C001) and number of year at sea (A124)}

\item{horodatedebut}{The starting date as a character, formats like \code{\%Y-\%m-\%d} or \code{\%d-\%m-\%Y} can be used as input}

\item{horodatefin}{The finishing date of the report, for this class this will be used to calculate the number of daily steps.}

\item{limit1hm}{Size limit of a salmon for an one sea winter fish}

\item{limit2hm}{Size limit of a salmon for a two sea winter fish}

\item{silent}{Default FALSE, if TRUE the program should no display messages}
}
\value{
An object of class \link{report_sea_age-class}
}
\description{
#' The choice_c method fills in the data slot for classes \link{ref_dc-class}, \link{ref_taxa-class}, \link{ref_stage-class}, \link{ref_par-class} and two slots of \link{ref_horodate-class} and then
uses the choice_c methods of these object to select the data.
}
\author{
Cedric Briand \email{cedric.briand"at"eptb-vilaine.fr}
}
