# launching stacomi without selecting the scheme or interface
stacomi(	database_expected=FALSE)
# the following script will load data from the two Anguillere monitored in the Somme

# If you have a working database
# the following line of code will create the r_silver dataset 
# from the "fd80." schema in the database
\dontrun{
	stacomi(database_expected=TRUE, sch="fd80.")	# overrides the default option sch = 'iav'
	# prompt for user and password, you can set these in the options, 
	# including dbname and host
	if (interactive()){
		if (!exists("user")){
			user <- readline(prompt="Enter user: ")
			password <- readline(prompt="Enter password: ")	
		}	
	}
	options(					
			stacomiR.dbname = "bd_contmig_nat",
			stacomiR.host ="localhost",
			stacomiR.port = "5432",
			stacomiR.user = user,
			stacomiR.user = password						
	)	
	
  #create an instance of the class
  r_silver<-new("report_silver_eel")
  r_silver<-choice_c(r_silver,
	  dc=c(2,6),			
	  horodatedebut="2010-09-01",
	  horodatefin="2016-10-04",
	  silent=FALSE)
  r_silver<-connect(r_silver)	
}	
# load the dataset generated by previous lines
data("r_silver")
# the calculation will fill the slot calcdata
r_silver<-calcule(r_silver)
# stages are in r_silver@calcdata[["6"]][,"stage"] 
#look at data structure using str(r_silver@calcdata[["6"]])

# standard plot as drawn by Laurent Beaulaton (Analyse des donnees d'argenture acquises en France)
# showing Durif's stage according to size and eye diameter
plot(r_silver, plot.type=1)

# number per month or year and Durif's stage (year if number of dc >1)
plot(r_silver, plot.type="2")

# plot showing fulton's coefficient, and size weight graphs
# inspired from Acou et al., 2009 
# Differential Production and Condition Indices of Premigrant
# Eels in Two Small Atlantic Coastal Catchments
# of France
plot(r_silver, plot.type="3")
# get a list of summary data and print output to screen

plot(r_silver, plot.type="4")
# print a summary statistic, and save the output in a list for later use
stats<-summary(r_silver)
