% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddStep.R
\name{AddStep}
\alias{AddStep}
\title{Create the workflow with the previous defined operation and data.}
\usage{
AddStep(inputs, step_fun, ...)
}
\arguments{
\item{inputs}{One or a list of objects of the class 'startR_cube' returned by 
Start(), indicating the data to be processed.}

\item{step_fun}{A startR step function as returned by Step().}

\item{\dots}{Additional parameters for the inputs of function defined in 
'step_fun' by Step().}
}
\value{
A list of the class 'startR_workflow' containing all the objects 
needed for the data operation.
}
\description{
The step that combines the previous declared data and operation together to 
create the complete workflow. It is the final step before data processing.
}
\examples{
 data_path <- system.file('extdata', package = 'startR')
 path_obs <- file.path(data_path, 'obs/monthly_mean/$var$/$var$_$sdate$.nc')
 sdates <- c('200011', '200012')
 data <- Start(dat = list(list(path = path_obs)),
               var = 'tos',
               sdate = sdates,
               time = 'all',
               latitude = 'all',
               longitude = 'all',
               return_vars = list(latitude = 'dat',
                                  longitude = 'dat',
                                  time = 'sdate'),
               retrieve = FALSE)
 pi_short <- 3.14
 fun <- function(x, pi_val) {
           lat = attributes(x)$Variables$dat1$latitude
           weight = sqrt(cos(lat * pi_val / 180))
           corrected = Apply(list(x), target_dims = "latitude",
                             fun = function(x) {x * weight})
         }


 step <- Step(fun = fun,
              target_dims = 'latitude',
              output_dims = 'latitude',
              use_libraries = c('multiApply'),
              use_attributes = list(data = "Variables"))
 wf <- AddStep(data, step, pi_val = pi_short)

}
