#' A Generic, Publisher-Independent Template for Writing Scientific Documents in
#' 'rmarkdown'
#'
#' This package provides a 'rmarkdown' template for authoring scientific documents
#' that is publisher independent. Though the template can be used by itself
#' for many types of scientific documents and likely for submitting publications
#' to many journals, it is primarily intended as a starter format for writing a
#' scientific publication before one has chosen a specific target journal.
#' Once an article has been written, the format can be quickly adapted for use
#' with the [rticles][rticles::oup_article()] package. See the package vignette
#' for more details.
#'
#' \tabular{ll}{ Package: \tab starticles\cr Type: \tab Package\cr Version:
#' \tab 0.1\cr Date: \tab 2022-06-07\cr License: \tab GPL (>= 3)\cr }
#'
#' @author David M. Kaplan \email{dmkaplan2000@@gmail.com}
#'
#' @name starticles
#' @docType package
#' @title A Generic, Publisher-Independent Template for Writing Scientific Documents in 'rmarkdown'
#' @keywords package
#' @example tests/test.starticles.R
#'
#' @seealso `browseVignettes("starticles")`, [rmarkdown][rmarkdown::rmarkdown-package()], [rticles][rticles::oup_article()]
NULL
