% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{graph.cor.test}
\alias{graph.cor.test}
\title{Test for Association / Correlation Between Paired Samples of Graphs}
\usage{
graph.cor.test(x, y)
}
\arguments{
\item{x}{a list of adjacency (symmetric) matrices of undirected graphs.
For unweighted graphs, each matrix contains only 0s and 1s. For weighted
graphs, each matrix contains real values that correspond to the weights of
the edges.}

\item{y}{a list with the same length of 'x'. It contains adjacency
(symmetric) matrices of undirected graphs. For unweighted graphs, each matrix
contains only 0s and 1s. For weighted graphs, each matrix may contain
real values that correspond to the weights of the edges.}
}
\value{
\item{statistic}{ the value of the test statistic.}
\item{p.value}{the p-value of the test.}
\item{estimate}{the estimated measure of association 'rho'.}
}
\description{
\code{graph.cor.test} tests for association between paired samples of graphs,
using Spearman's rho correlation coefficient.
}
\examples{
require(igraph)
x <- list()
y <- list()

p <- MASS::mvrnorm(50, mu=c(0,0), Sigma=matrix(c(1, 0.5, 0.5, 1), 2, 2))

ma <- max(p)
mi <- min(p)
p[,1] <- (p[,1] - mi)/(ma - mi)
p[,2] <- (p[,2] - mi)/(ma - mi)

for (i in 1:50) {
    x[[i]] <- get.adjacency(erdos.renyi.game(50, p[i,1]))
    y[[i]] <- get.adjacency(erdos.renyi.game(50, p[i,2]))
}

graph.cor.test(x, y)

}
\references{
Fujita, A., Takahashi, D. Y., Balardin, J. B., Vidal, M. C. and Sato, J. R.
(2017) Correlation between graphs with an application to brain network
analysis. _Computational Statistics & Data Analysis_ *109*, 76-92.
}
\keyword{correlation_coefficient}
