/*
 * Decompiled with CFR 0.152.
 */
package sample;

import dag.Dag;
import haplotype.BasicSampleHapPairs;
import haplotype.ConsensusPhaser;
import haplotype.HapPair;
import haplotype.RevSampleHapPairs;
import haplotype.SampleHapPairs;
import haplotype.Weights;
import java.util.ArrayList;
import java.util.List;
import main.CurrentData;
import main.Par;
import main.RunStats;
import sample.RestrictedDag;
import vcf.FuzzyGL;
import vcf.GL;
import vcf.Markers;
import vcf.RevGL;

public class SamplerData {
    private static final double MIN_CM_DIST = 1.0E-7;
    private static final int nInitLevels = 500;
    private final Par par;
    private final boolean revMarkers;
    private final RestrictedDag rdag;
    private final GL gl;
    private final float[] recombRate;

    public SamplerData(Par par, CurrentData currentData, List<HapPair> list, boolean bl, RunStats runStats) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("hapPairs.isEmpty()");
        }
        this.par = par;
        this.revMarkers = bl;
        this.rdag = this.restrictedDag(currentData, list, bl, runStats);
        this.gl = SamplerData.gl(currentData, par.err(), bl);
        this.recombRate = SamplerData.recombRate(par, currentData, this.rdag.dag(), bl);
    }

    private static float[] recombRate(Par par, CurrentData currentData, Dag dag, boolean bl) {
        float[] fArray = currentData.recombRate();
        if (fArray != null && bl) {
            int n = (fArray.length + 1) / 2;
            for (int i = 1; i < n; ++i) {
                int n2 = fArray.length - i;
                float f = fArray[i];
                fArray[i] = fArray[n2];
                fArray[n2] = f;
            }
            fArray[0] = 0.0f;
        } else {
            fArray = SamplerData.dagRecombRate(dag, par.mapscale());
        }
        return fArray;
    }

    private RestrictedDag restrictedDag(CurrentData currentData, List<HapPair> list, boolean bl, RunStats runStats) {
        list = new ArrayList<HapPair>(list);
        long l = System.nanoTime();
        Weights weights = currentData.weights();
        List<HapPair> list2 = ConsensusPhaser.run(list);
        currentData.addRestrictedRefHapPairs(list2);
        SampleHapPairs sampleHapPairs = new BasicSampleHapPairs(currentData.allSamples(), list2);
        if (bl) {
            sampleHapPairs = new RevSampleHapPairs(sampleHapPairs);
        }
        float[] fArray = weights.get(sampleHapPairs);
        RestrictedDag restrictedDag = new RestrictedDag(sampleHapPairs, fArray, 500, this.par.modelscale(), this.par.ibdlength(), this.par.ibdextend());
        runStats.buildNanos(System.nanoTime() - l);
        runStats.setDagStats(restrictedDag.dag());
        return restrictedDag;
    }

    private static float[] dagRecombRate(Dag dag, float f) {
        double[] dArray = dag.posArray();
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * 0.2;
        }
        double d = -2.0 * (double)f;
        float[] fArray = new float[dag.nLevels()];
        fArray[0] = 0.0f;
        double d2 = dArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            double d3 = dArray[i];
            double d4 = Math.max(Math.abs(d3 - d2), 1.0E-7);
            fArray[i] = (float)(-Math.expm1(d * d4));
            d2 = d3;
        }
        return fArray;
    }

    private static GL gl(CurrentData currentData, float f, boolean bl) {
        GL gL = new FuzzyGL(currentData.targetGL(), f);
        if (bl) {
            gL = new RevGL(gL);
        }
        return gL;
    }

    public boolean markersAreReversed() {
        return this.revMarkers;
    }

    public int nMarkers() {
        return this.gl.nMarkers();
    }

    public int nSamples() {
        return this.gl.nSamples();
    }

    public int nHaps() {
        return 2 * this.gl.nSamples();
    }

    public Markers markers() {
        return this.gl.markers();
    }

    public Par par() {
        return this.par;
    }

    public RestrictedDag rdag() {
        return this.rdag;
    }

    public GL gl() {
        return this.gl;
    }

    public float err() {
        return this.par.err();
    }

    public float pRecomb(int n) {
        return this.recombRate[n];
    }
}

