% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTimePoints.R
\name{getTimePoints}
\alias{getTimePoints}
\title{Extract time points}
\usage{
getTimePoints(x)
}
\arguments{
\item{x}{An object of class TP or fitMod}
}
\value{
A data.frame with columns timeNumber and timePoint listing the
time points in x
}
\description{
Function for extracting a data.frame with timeNumbers and timePoints from
an object of class TP or fitMod.
}
\examples{
## Create an object of class TP.
phenoTP <- createTimePoints(dat = PhenovatorDat1,
                            experimentName = "Phenovator",
                            genotype = "Genotype",
                            timePoint = "timepoints",
                            repId = "Replicate",
                            plotId = "pos",
                            rowNum = "y", colNum = "x",
                            addCheck = TRUE,
                            checkGenotypes = c("check1", "check2",
                                               "check3", "check4"))

## Extract the time points from the object.
head(getTimePoints(phenoTP))

}
\seealso{
Other functions for data preparation: 
\code{\link{as.data.frame.TP}()},
\code{\link{createTimePoints}()},
\code{\link{plot.TP}()},
\code{\link{removeTimePoints}()},
\code{\link{summary.TP}()}
}
\concept{functions for data preparation}
