% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{updateFA}
\alias{updateFA}
\title{Update W and P in EMFA algorithm}
\usage{
updateFA(
  y,
  wStart,
  pStart,
  wNew,
  pNew,
  m0,
  hetVar = FALSE,
  maxDiag = 10000,
  tolerance = 1e-04,
  maxIter = 100L,
  printProgress = FALSE
)
}
\arguments{
\item{hetVar}{Should an extra diagonal part be added in the model for the
precision matrix?}

\item{maxDiag}{A numerical value for the maximum value of the diagonal of P.}

\item{tolerance}{A numerical value. The iterating process stops if the sum
of the difference for P and W between two steps gets lower than this value.}

\item{maxIter}{A numerical value for the maximum number of iterations.}

\item{printProgress}{Should progress be printed during iterations?}

\item{Y}{An n x p matrix or data.frame.}

\item{WStart}{A p x p matrix or data.frame containing starting values for W.}

\item{m}{An integer. The order of the model.}

\item{PStart}{A p x p matrix or data.frame containing starting values for P.}
}
\description{
Update W and P used in the iteration process in the EMFA algorithm.
}
\keyword{internal}
