% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.2x2.median.bs}
\alias{ci.2x2.median.bs}
\title{Computes tests and confidence intervals of effects in a 2x2 betwen-subjects
design for medians}
\usage{
ci.2x2.median.bs(alpha, y11, y12, y21, y22)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y11}{vector of scores at level 1 of A and level 1 of B}

\item{y12}{vector of scores at level 1 of A and level 2 of B}

\item{y21}{vector of scores at level 2 of A and level 1 of B}

\item{y22}{vector of scores at level 2 of A and level 2 of B}
}
\value{
Returns a 7-row matrix (one row per effect). The columns are:
\itemize{
\item Estimate - estimate of effect
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes confidence intervals for the AB interaction effect, main effect of
A, main efect of B, simple main effects of A, and simple main effects of B
in a 2x2 between-subjects design with a quantitative response variable. The
effects are defined in terms of medians rather than means.
}
\examples{
y11 <- c(14, 15, 11, 7, 16, 12, 15, 16, 10, 9)
y12 <- c(18, 24, 14, 18, 22, 21, 16, 17, 14, 13)
y21 <- c(16, 11, 10, 17, 13, 18, 12, 16, 6, 15)
y22 <- c(18, 17, 11, 9, 9, 13, 18, 15, 14, 11)
ci.2x2.median.bs(.05, y11, y12, y21, y22)

# Should return:
#          Estimate       SE         LL         UL
# AB:          -5.0 3.389735 -11.643758 1.64375833
# A:            1.5 1.694867  -1.821879 4.82187916
# B:           -2.0 1.694867  -5.321879 1.32187916
# A at b1:     -1.0 2.152661  -5.219138 3.21913797
# A at b2:      4.0 2.618464  -1.132095 9.13209504
# B at a1:     -4.5 2.311542  -9.030539 0.03053939
# B at a2:      0.5 2.479330  -4.359397 5.35939682


}
