% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{pi.score.ps}
\alias{pi.score.ps}
\title{Prediction interval for difference of scores in a 2-level within-subjects
experiment}
\usage{
pi.score.ps(alpha, m1, m2, sd1, sd2, cor, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{estimated mean from group 1}

\item{m2}{estimated mean from group 2}

\item{sd1}{estimated standard deviation from group 1}

\item{sd2}{estimated standard deviation from group 2}

\item{cor}{estimated correlation of paired scores}

\item{n}{sample size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Predicted - predicted difference in scores
\item df - degrees of freedom
\item LL - lower limit of the prediction interval
\item UL - upper limit of the prediction interval
}
}
\description{
For a 2-level within-subjects experiment, this function computes a
prediction interval for how the response variable score for one randomly
selected person from the study population would differ under the two
treatment conditions.
}
\examples{
pi.score.ps(.05, 265.1, 208.6, 23.51, 19.94, .814, 30)

# Should return:
# Predicted df       LL       UL
#      56.5 29 28.05936 84.94064
 

}
