% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_t_test.R
\name{expr_t_nonparametric}
\alias{expr_t_nonparametric}
\title{Making expression for Mann-Whitney \emph{U}-test/Wilcoxon test results}
\usage{
expr_t_nonparametric(
  data,
  x,
  y,
  subject.id = NULL,
  paired = FALSE,
  k = 2L,
  conf.level = 0.95,
  conf.type = "norm",
  nboot = 100,
  output = "expression",
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{subject.id}{In case of repeated measures design (\code{paired = TRUE},
i.e.), this argument specifies the subject or repeated measures id. Note
that if this argument is \code{NULL} (which is the default), the function
assumes that the data has already been sorted by such an id by the user and
creates an internal identifier. So if your data is \strong{not} sorted and you
leave this argument unspecified, the results can be inaccurate.}

\item{paired}{Logical that decides whether the experimental design is
repeated measures/within-subjects or between-subjects. The default is
\code{FALSE}.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} confidence/credible intervals (\code{0.95}).}

\item{conf.type}{A vector of character strings representing the type of
intervals required. The value should be any subset of the values \code{"norm"},
\code{"basic"}, \code{"perc"}, \code{"bca"}. For more, see \code{?boot::boot.ci}.}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{output}{If \code{"expression"}, will return expression with statistical
details, while \code{"dataframe"} will return a dataframe containing the
results.}

\item{...}{Additional arguments (currently ignored).}
}
\description{
Making expression for Mann-Whitney \emph{U}-test/Wilcoxon test results
}
\details{
For the two independent samples case, the Mann-Whitney \emph{U}-test is
calculated and \emph{W} is reported from \emph{stats::wilcox.test}. For the paired
samples case the Wilcoxon signed rank test is run and \emph{V} is reported.

Since there is no single commonly accepted method for reporting effect size
for these tests we are computing and reporting \emph{r} (computed as
\eqn{Z/\sqrt{N}}) along with the confidence intervals associated with the
estimate. Note that \emph{N} here corresponds to total \emph{sample size} for
independent/between-subjects designs, and to total number of \emph{pairs} (and
\strong{not} \emph{observations}) for repeated measures/within-subjects designs.

\emph{Note:} The \emph{stats::wilcox.test} function does not follow the
same convention as \emph{stats::t.test}. The sign of the \emph{V} test statistic
will always be positive since it is \strong{the sum of the positive signed ranks}.
Therefore, \emph{V} will vary in magnitude but not significance based solely
on the order of the grouping variable. Consider manually
reordering your factor levels if appropriate as shown in the second example
below.
}
\examples{
# for reproducibility
set.seed(123)
library(statsExpressions)

# -------------- between-subjects design ------------------------

expr_t_nonparametric(
  data = sleep,
  x = group,
  y = extra
)

# -------------- within-subjects design ------------------------

expr_t_nonparametric(
  data = VR_dilemma,
  x = modality,
  y = score,
  paired = TRUE,
  subject.id = id
)
}
\references{
For more details, see-
\url{https://indrajeetpatil.github.io/statsExpressions/articles/stats_details.html}
}
