% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_twosample.R
\name{expr_t_twosample}
\alias{expr_t_twosample}
\title{Expression and dataframe for two-sample \emph{t}-test}
\usage{
expr_t_twosample(
  data,
  x,
  y,
  subject.id = NULL,
  type = "parametric",
  paired = FALSE,
  k = 2L,
  conf.level = 0.95,
  effsize.type = "g",
  var.equal = FALSE,
  bf.prior = 0.707,
  tr = 0.2,
  nboot = 100,
  top.text = NULL,
  output = "expression",
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{subject.id}{In case of repeated measures design (\code{paired = TRUE},
i.e.), this argument specifies the subject or repeated measures id. Note
that if this argument is \code{NULL} (which is the default), the function
assumes that the data has already been sorted by such an id by the user and
creates an internal identifier. So if your data is \strong{not} sorted and you
leave this argument unspecified, the results can be inaccurate.}

\item{type}{A character specifying the type of statistical approach.
Four possible options:

\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

Corresponding abbreviations are also accepted: \code{"p"} (for parametric),
\code{"np"} (for nonparametric), \code{"r"} (for robust), or \code{"bf"} (for Bayesian).}

\item{paired}{Logical that decides whether the experimental design is
repeated measures/within-subjects or between-subjects. The default is
\code{FALSE}.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{conf.level}{Confidence/Credible Interval (CI) level. Default to \code{0.95}
(\verb{95\%}).}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"d"} (for Cohen's \emph{d}) or \code{"g"} (for Hedge's \emph{g}).}

\item{var.equal}{a logical variable indicating whether to treat the
    two variances as being equal. If \code{TRUE} then the pooled
    variance is used to estimate the variance otherwise the Welch
    (or Satterthwaite) approximation to the degrees of freedom is used.}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors and posterior estimates.}

\item{tr}{Trim level for the mean when carrying out \code{robust} tests. In case
of an error, try reducing the value of \code{tr}, which is by default set to
\code{0.2}. Lowering the value might help.}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{top.text}{Text to display on top of the Bayes Factor message. This is
mostly relevant in the context of \code{ggstatsplot} functions.}

\item{output}{If \code{"expression"}, will return expression with statistical
details, while \code{"dataframe"} will return a dataframe containing the
results.}

\item{...}{Currently ignored.}
}
\description{
\Sexpr[results=rd, stage=render]{rlang:::lifecycle("maturing")}

A dataframe containing details from results of a two-sample test and effect
size plus confidence intervals.

For more details, see-
\url{https://indrajeetpatil.github.io/statsExpressions/articles/stats_details.html}
}
\note{
The \emph{stats::wilcox.test} function does not follow the same convention
as \emph{stats::t.test}. The sign of the \emph{V} test statistic will always be
positive since it is \strong{the sum of the positive signed ranks}. Therefore,
\emph{V} will vary in magnitude but not significance based solely on the order
of the grouping variable. Consider manually reordering your factor levels
if appropriate as shown in the second example below.
}
\examples{
\donttest{
# for reproducibility
set.seed(123)
library(statsExpressions)

# ----------------------- parametric -------------------------------------

# between-subjects design
expr_t_twosample(
  data = sleep,
  x = group,
  y = extra,
  type = "p"
)

# within-subjects design
expr_t_twosample(
  data = VR_dilemma,
  x = modality,
  y = score,
  paired = TRUE,
  subject.id = id,
  type = "p",
  output = "dataframe"
)

# ----------------------- non-parametric ----------------------------------

# between-subjects design
expr_t_twosample(
  data = sleep,
  x = group,
  y = extra,
  type = "np"
)

# within-subjects design
expr_t_twosample(
  data = VR_dilemma,
  x = modality,
  y = score,
  paired = TRUE,
  subject.id = id,
  type = "np",
  output = "dataframe"
)

# ------------------------------ robust ----------------------------------

# between-subjects design
expr_t_twosample(
  data = sleep,
  x = group,
  y = extra,
  type = "r"
)

# within-subjects design
expr_t_twosample(
  data = VR_dilemma,
  x = modality,
  y = score,
  paired = TRUE,
  subject.id = id,
  type = "r",
  output = "dataframe"
)

#' # ------------------------------ Bayesian ------------------------------

# between-subjects design
expr_t_twosample(
  data = sleep,
  x = group,
  y = extra,
  type = "bayes"
)

# within-subjects design
expr_t_twosample(
  data = VR_dilemma,
  x = modality,
  y = score,
  paired = TRUE,
  subject.id = id,
  type = "bayes",
  output = "dataframe"
)
}
}
