% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cond_expand.R
\name{cond_expand}
\alias{cond_expand}
\title{Create interaction expansion}
\usage{
cond_expand(data, case.ids, outcome, conditions, inter.func)
}
\arguments{
\item{data}{a data frame}

\item{case.ids}{optional character vector containing variable names that identify cases}

\item{outcome}{a character string containing the name of the outcome variable}

\item{conditions}{an optional character vector containing the names of the causal factors}

\item{inter.func}{a function that combines the constituent values of an interaction}
}
\value{
Returns a data frame
}
\description{
\code{cond_expand} expands a dataset to include interaction values for
all possible combinations of its variables.
}
\examples{
# Load data
data(hicks_20)

# Combine values via "min" function
cond_expand(data = hicks_20, case.ids = "Case", outcome = "CON")

# Combine values via "mean" function
cond_expand(data = hicks_20, case.ids = "Case", outcome = "CON", inter.func = "mean")
}

