% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_vcs.R
\name{calculate_vcs}
\alias{calculate_vcs}
\title{Extracts varying coefficient estimates (for SVC, TVC and STVC models).}
\usage{
calculate_vcs(input_data, mgcv_model, terms = NULL)
}
\arguments{
\item{input_data}{the data used to create the GAM model in \code{data.frame}, \code{tibble} or \code{sf} format. This can be the original data used to create the model or another surface with location and time attributes.}

\item{mgcv_model}{a GAM model with smooths created using the \code{mgcv} package}

\item{terms}{a vector of names starting with "Intercept" plus the names of the covariates used in the GAM model (these are the names of the variables in the \code{input_data} used to construct the model).}
}
\value{
A \code{data.frame} of the input data and the coefficient and standard error estimates for each covariate. It can be used to generate coefficient estimates for specific time slices and over grided surfaces as described in the package vignette.
}
\description{
Extracts varying coefficient estimates (for SVC, TVC and STVC models).
}
\examples{
require(dplyr)
require(doParallel)
# define input data
data("hp_data")
input_data <-
  hp_data |>
  # create Intercept as an addressable term
  mutate(Intercept = 1)
# create a model for example as result of running `evaluate_models`
gam.m = gam(priceper ~ Intercept - 1 + s(X, Y, by = Intercept) +
 s(X, Y, by = pef) + s(X, Y, by = beds), data = input_data)
# calculate the Varying Coefficients
terms = c("Intercept", "pef", "beds")
vcs = calculate_vcs(input_data, gam.m, terms)
vcs |> select(priceper, X, Y, starts_with(c("b_", "se_")), yhat)

}
