% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotModels.R
\name{plotModels}
\alias{plotModels}
\title{Plots semantic coherence and exclusivity for high likelihood models
outputted from selectModel.}
\usage{
plotModels(models, xlab = "Semantic Coherence", ylab = "Exclusivity",
  labels = 1:length(models$runout), pch = NULL,
  legend.position = "topleft", ...)
}
\arguments{
\item{models}{Output from selectModel.}

\item{xlab}{Character string that is x axis title. This will be semantic
coherence.}

\item{ylab}{Character string that is y axis title. This will be exclusivity.}

\item{labels}{Labels for each model.}

\item{pch}{A vector of integers specifying symbol for plotting.}

\item{legend.position}{The location of the legend.  Can be \code{"bottomright", 
"bottom", "bottomleft", "left", "topleft", "top", "topright", "right"} and 
\code{"center"}.}

\item{...}{Other plotting parameters.}
}
\description{
Plots semantic coherence and exclusivity for high likelihood models.  In the
case of models that include content covariates, prints semantic coherence
and sparsity.
}
\details{
Each model has semantic coherence and exclusivity values associated with
each topic.  In the default plot function, the small colored dots are
associated with a topic's semantic coherence and exclusivity.  Dots with the
same color as topics associated with the same model.  The average semantic
coherence and exclusivity is also plotted in the same color, but printed as
the model number associated with the output from selectModels().

With content covariates, the model does not output exclusivity because
exclusivity has been built in with the content covariates.  Instead, the
user should check to make sure that sparsity is high enough (typically
greater than .5), and then should select a model based on semantic
coherence.
}
