% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serialization.R
\name{loadRandomEffectSamplesJson}
\alias{loadRandomEffectSamplesJson}
\title{Load a container of random effect samples from json}
\usage{
loadRandomEffectSamplesJson(json_object, json_rfx_num)
}
\arguments{
\item{json_object}{Object of class \code{CppJson}}

\item{json_rfx_num}{Integer index indicating the position of the random effects term to be unpacked}
}
\value{
\code{RandomEffectSamples} object
}
\description{
Load a container of random effect samples from json
}
\examples{
n <- 100
p <- 10
X <- matrix(runif(n*p), ncol = p)
rfx_group_ids <- sample(1:2, size = n, replace = TRUE)
rfx_basis <- rep(1.0, n)
y <- (-5 + 10*(X[,1] > 0.5)) + (-2*(rfx_group_ids==1)+2*(rfx_group_ids==2)) + rnorm(n)
bart_model <- bart(X_train=X, y_train=y, rfx_group_ids_train=rfx_group_ids,
                   rfx_basis_train = rfx_basis, num_gfr=0, num_mcmc=10)
bart_json <- saveBARTModelToJson(bart_model)
rfx_samples <- loadRandomEffectSamplesJson(bart_json, 0)
}
