% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.bnd.R
\name{calc.bnd}
\alias{calc.bnd}
\title{Stopping Boundary Calculation}
\usage{
calc.bnd(n, p0, cval, type, param)
}
\arguments{
\item{n}{Maximum sample size for safety monitoring}

\item{p0}{The toxicity rate under the null hypothesis}

\item{cval}{Critical value for stopping rule method}

\item{type}{The method used for constructing the stopping rule}

\item{param}{Extra parameter(s) needed for certain stopping rule methods. For binomial Wang-Tsiatis tests, this is the Delta parameter. For Bayesian beta-binomial model, this is the pair of hyperparameters for the beta prior on the toxicity rate. For modified SPRT, this is the targeted alternative toxicity rate p1.}
}
\value{
A vector of stopping boundaries at the sample sizes 1, 2, ..., n
}
\description{
Internal workhorse function to calculate stopping boundary for a given method
}
