% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OC.rule.surv.R
\name{OC.rule.surv}
\alias{OC.rule.surv}
\title{Operating Characteristics Function (Survival Data)}
\usage{
OC.rule.surv(rule, ps)
}
\arguments{
\item{rule}{A 'rule.surv' object calculated by \code{calc.rule.surv()} function}

\item{ps}{A vector of toxicity probabilities at which the operating characteristics will be computed}
}
\value{
A matrix with four columns: the toxicity probability \code{ps}, the corresponding
rejection probabilities, and the corresponding expected total follow up time and number of events at the point of stopping/study end
}
\description{
Compute operating characteristics for a stopping rule at a set of toxicity rates.
Characteristics calculated include the overall rejection probability, the expected
number of patients evaluated, and the expected number of events for time-to-event data
}
\examples{
pocock.rule <- calc.rule.surv(n = 30, p0 = 0.1, alpha = 0.05, tau = 100, type = "Pocock")
OC.rule.surv(rule = pocock.rule, ps = seq(0.1, 0.5, 0.1))
}
