% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apportion_polygon.R
\name{apportion_polygon}
\alias{apportion_polygon}
\title{Distribute streamflow depletion within a stream network using web distance Thiessen polygons.}
\usage{
apportion_polygon(reach_dist_lon_lat, wel_lon, wel_lat, crs,
  max_dist = Inf, min_frac = 0, reach_name = NULL,
  dist_name = NULL, lon_name = NULL, lat_name = NULL)
}
\arguments{
\item{reach_dist_lon_lat}{data frame with four columns: \code{reach}, which is a grouping variable with
the name of each stream reach; \code{dist} which is the distance of a point on that stream reach to
the well of interest; \code{lon} which is the longitude of that point on the stream; and
\code{lat} which is the latitude of that point on the stream. There can (and likely will) be multiple rows per \code{reach}.
Columns can either be named exactly as defined here, or set using \code{reach_name}, \code{dist_name}, \code{lon_name}, and \code{lat_name}.}

\item{wel_lon}{longitude of well}

\item{wel_lat}{latitude of well}

\item{crs}{object of class CRS with projection info of latitude and longitude input}

\item{max_dist}{the maximum distance of a stream to be depleted; defaults to \code{Inf}, which means all reaches will be considered.}

\item{min_frac}{the minimum \code{frac_depletion} to be returned; defaults to \code{0}, which means all reaches will be considered.
If \code{min_frac > 0} and some reaches have an estimated \code{frac_depletion < min_frac}, depletion in those reaches will be set to 0
and that depletion will be reallocated based on the proportional depletion in the remaining reaches.}

\item{reach_name}{The name of the column in \code{reach_dist} indicating your stream reach grouping variable. If set to \code{NULL} (default), it will assume that the column name is \code{reach}.}

\item{dist_name}{The name of the column in \code{reach_dist} indicating your distance variable. If set to \code{NULL} (default), it will assume that the column name is \code{dist}.}

\item{lon_name}{The name of the column in \code{reach_dist} indicating your longitude variable. If set to \code{NULL} (default), it will assume that the column name is \code{lon}.}

\item{lat_name}{The name of the column in \code{reach_dist} indicating your latitude variable. If set to \code{NULL} (default), it will assume that the column name is \code{lat}.}
}
\value{
A data frame with two columns:
\describe{
  \item{reach}{the grouping variable input in \code{reach_dist}}
  \item{frac_depletion}{the proportion of streamflow depletion from the well occurring in that reach.}
}
}
\description{
Distribute streamflow depletion within a stream network using web distance Thiessen polygons.
}
\details{
Since analytical models assume the presence of 1 (or sometimes 2) linear streams, the \code{apportion_*} functions
can be used to distribute that depletion to various reaches within a real stream network. These geometric functions are described
in Zipper et al (2018), which found that \code{apportion_web} a weighting factor (\code{w}) of 2 produced the best results.
}
\examples{
rdll <- prep_reach_dist(wel_lon = 295500, wel_lat = 4783200,
   stream_shp = stream_lines, reach_id = "reach", stream_pt_spacing = 1)
apportion_polygon(reach_dist_lon_lat = rdll, wel_lon = 295500, wel_lat = 4783200,
   max_dist = 5000, crs = raster::crs(stream_lines))
}
\references{
Zipper, SC, T Dallemagne, T Gleeson, TC Boerman, A Hartmann (2018). Groundwater Pumping Impacts
on Real Stream Networks: Testing the Performance of Simple Management Tools. Water Resources Research.
doi:10.1029/2018WR022707.
}
