% Generated by roxygen2 (4.0.0): do not edit by hand
\name{stri_pad_both}
\alias{stri_pad}
\alias{stri_pad_both}
\alias{stri_pad_left}
\alias{stri_pad_right}
\title{Pad (Center/Left/Right Align) a String}
\usage{
stri_pad_both(str, min_length = floor(0.9 * getOption("width")), pad = " ")

stri_pad_left(str, min_length = floor(0.9 * getOption("width")), pad = " ")

stri_pad_right(str, min_length = floor(0.9 * getOption("width")), pad = " ")

stri_pad(str, min_length = floor(0.9 * getOption("width")), side = c("left",
  "right", "both"), pad = " ")
}
\arguments{
\item{str}{character vector}

\item{min_length}{integer vector giving minimal output string lengths}

\item{side}{[\code{stri_pad} only] single character string;
sides on which padding character is added
(\code{left}, \code{right}, or \code{both})}

\item{pad}{character vector giving padding code points}
}
\value{
Returns a character vector.
}
\description{
Adds multiple \code{pad} characters at the given \code{side}(s) of each string
so that each output string consists of at least \code{min_length} code points.
This function may be used to center or left/right-align each string.
}
\details{
Vectorized over \code{str}, \code{min_length}, and \code{pad}.
Each string in \code{pad} should consist of exactly one code point.

\code{stri_pad} is a convenience function, which dispatches
control to \code{stri_pad_*}. Unless you are very lazy, do not use it:
it is a little bit slower.

Note that Unicode code points may have various widths when
printed on screen. This function acts like each code point
is of width 1. This function should rather be used with
text in Latin script.

See \code{\link{stri_trim_left}} (among others) for reverse operation.
Also check out \code{\link{stri_wrap}} for line wrapping.
}
\examples{
stri_pad_left("stringi", 10, pad="#")
stri_pad_both("stringi", 8:12, pad="*")
# center on screen:
cat(stri_pad_both(c("the", "string", "processing", "package"),
   getOption("width")*0.9), sep='\\n')
}

