% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sudokuAlt.R
\name{fetchAUGame}
\alias{fetchAUGame}
\title{Retrieve a Sudoku from the AU Site}
\usage{
fetchAUGame(day = 0, difficulty = c("tough", "hard", "medium", "easy"))
}
\arguments{
\item{day}{non-negative integer, how many days ago? zero for
today's game.}

\item{difficulty}{character string, how hard would you like it?}
}
\value{
The published sudoku game as a sudoku object.
}
\description{
Retrieve a Sudoku Game
}
\details{
Connects to \url{http://www.sudoku.com.au} and retrieves
the sudoku game from \code{day} days ago.  Based on a function from a
related sudoku package, \code{sudoku::fetchSudokuUK} with minor changes.
}
\examples{
\dontrun{
(g0 <- fetchAUGame())           ## The 'easy' game for today 
(g3 <- fetchAUGame(3, "tough")) ## 'tough' game from 3 days ago
plot(solve(g3))                 ## Spoil the game!
}
}
\author{
Bill Venables
}
