% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sun.R
\name{.balanceCrdsTimes}
\alias{.balanceCrdsTimes}
\title{Balance coordinates and times}
\usage{
.balanceCrdsTimes(crds, dateTime)
}
\arguments{
\item{crds}{A matrix with longitude and latitude coordinates.}

\item{dateTime}{A matrix with year, month, day, timezone, and daylight saving time rows, or a POSIXct time.}
}
\value{
A list with 'crds' and 'dateTime' matrices, both with the same number of rows.
}
\description{
Ensures that the 'crds' and 'dateTime' inputs have the same number of rows.
If 'crds' has a single row but 'dateTime' has multiple rows, 'crds' is replicated to match 'dateTime'.
Similarly, if 'dateTime' has a single row but 'crds' has multiple rows, 'dateTime' is replicated to match 'crds'.
If 'crds' and 'dateTime' have different numbers of rows and neither has just one row, an error is thrown.
}
\keyword{internal}
