% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target_encoders.R
\name{kFoldMean}
\alias{kFoldMean}
\title{kFoldMean Calculator}
\usage{
kFoldMean(train_df, test_df, colname, target, n_fold = 5, seed = 42)
}
\arguments{
\item{train_df}{train dataset}

\item{test_df}{test dataset}

\item{colname}{name of categorical column}

\item{target}{the target or dependent variable, should be a string.}

\item{n_fold}{the number of folds to use for doing kfold computation, default=5}

\item{seed}{the seed value, to ensure reproducibility,
it could be any positive value, default=42}
}
\value{
a train and test data table with out-of-fold mean value
        of the target for the given categorical variable
}
\description{
Calculates out-of-fold mean features (also known as target encoding) for train and test data. Make sure to rbind both train and test into one data frame.
This strategy is widely used to avoid overfitting or causing leakage while creating features using the target variable.
}
\examples{
train <- data.frame(region=c('del','csk','rcb','del','csk','pune','guj','del'),
                    win = c(0,1,1,0,0,0,0,1))
test <- data.frame(region=c('rcb','csk','rcb','del','guj','pune','csk','kol'))
train_result <- kFoldMean(train_df = train,
                          test_df = test,
                          colname = 'region',
                          target = 'win',
                          seed = 1220)$train

test_result <- kFoldMean(train_df = train,
                         test_df = test,
                         colname = 'region',
                         target = 'win',
                         seed = 1220)$test
}
