% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LabelEncoder.R
\name{LabelEncoder}
\alias{LabelEncoder}
\title{Label Encoder}
\format{
\code{\link{R6Class}} object.
}
\description{
Encodes and decodes categorical variables into integer values and vice versa.
This is a commonly performed task in data preparation during model training, because all machine learning models require
the data to be encoded into numerical format. It takes a vector of character or factor values and encodes them into numeric.
}
\section{Usage}{

For usage details see \bold{Methods, Arguments and Examples} sections.
\preformatted{
lbl = LabelEncoder$new()
lbl$fit(x)
lbl$fit_transform(x)
lbl$transform(x)
}
}

\section{Methods}{

\describe{
  \item{\code{$new()}}{Initialise the instance of the encoder}
  \item{\code{$fit()}}{creates a memory of encodings but doesn't return anything}
  \item{\code{$transform()}}{based on encodings learned in \code{fit} method is applies the transformation}
  \item{\code{$fit_transform()}}{encodes the data and keep a memory of encodings simultaneously}
  \item{\code{$inverse_transform()}}{encodes the data and keep a memory of encodings simultaneously}
}
}

\section{Arguments}{

\describe{
 \item{data}{a vector or list containing the character / factor values}
}
}

\examples{
data_ex <- data.frame(Score = c(10,20,30,4), Name=c('Ao','Bo','Bo','Co'))
lbl <- LabelEncoder$new()
data_ex$Name <- lbl$fit_transform(data_ex$Name)
decode_names <- lbl$inverse_transform(data_ex$Name)

## ------------------------------------------------
## Method `LabelEncoder$fit`
## ------------------------------------------------

data_ex <- data.frame(Score = c(10,20,30,4), Name=c('Ao','Bo','Bo','Co'))
lbl <- LabelEncoder$new()
lbl$fit(data_ex$Name)
data_ex$Name <- lbl$fit_transform(data_ex$Name)
decode_names <- lbl$inverse_transform(data_ex$Name)

## ------------------------------------------------
## Method `LabelEncoder$fit_transform`
## ------------------------------------------------

data_ex <- data.frame(Score = c(10,20,30,4), Name=c('Ao','Bo','Bo','Co'))
lbl <- LabelEncoder$new()
lbl$fit(data_ex$Name)
data_ex$Name <- lbl$fit_transform(data_ex$Name)

## ------------------------------------------------
## Method `LabelEncoder$transform`
## ------------------------------------------------

data_ex <- data.frame(Score = c(10,20,30,4), Name=c('Ao','Bo','Bo','Co'))
lbl <- LabelEncoder$new()
lbl$fit(data_ex$Name)
data_ex$Name <- lbl$transform(data_ex$Name)

## ------------------------------------------------
## Method `LabelEncoder$inverse_transform`
## ------------------------------------------------

data_ex <- data.frame(Score = c(10,20,30,4), Name=c('Ao','Bo','Bo','Co'))
lbl <- LabelEncoder$new()
lbl$fit(data_ex$Name)
data_ex$Name <- lbl$fit_transform(data_ex$Name)
decode_names <- lbl$inverse_transform(data_ex$Name)
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{input_data}}{internal use}

\item{\code{encodings}}{internal use}

\item{\code{decodings}}{internal use}

\item{\code{fit_model}}{internal use}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-fit}{\code{LabelEncoder$fit()}}
\item \href{#method-fit_transform}{\code{LabelEncoder$fit_transform()}}
\item \href{#method-transform}{\code{LabelEncoder$transform()}}
\item \href{#method-inverse_transform}{\code{LabelEncoder$inverse_transform()}}
\item \href{#method-clone}{\code{LabelEncoder$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\if{latex}{\out{\hypertarget{method-fit}{}}}
\subsection{Method \code{fit()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LabelEncoder$fit(data_col)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_col}}{a vector containing non-null values}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Fits the labelencoder model on given data
}

\subsection{Returns}{
NULL, calculates the encoding and save in memory
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data_ex <- data.frame(Score = c(10,20,30,4), Name=c('Ao','Bo','Bo','Co'))
lbl <- LabelEncoder$new()
lbl$fit(data_ex$Name)
data_ex$Name <- lbl$fit_transform(data_ex$Name)
decode_names <- lbl$inverse_transform(data_ex$Name)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit_transform"></a>}}
\if{latex}{\out{\hypertarget{method-fit_transform}{}}}
\subsection{Method \code{fit_transform()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LabelEncoder$fit_transform(data_col)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_col}}{a vector containing non-null values}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Fits and returns the encoding
}

\subsection{Returns}{
encoding values for the given input data
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data_ex <- data.frame(Score = c(10,20,30,4), Name=c('Ao','Bo','Bo','Co'))
lbl <- LabelEncoder$new()
lbl$fit(data_ex$Name)
data_ex$Name <- lbl$fit_transform(data_ex$Name)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-transform"></a>}}
\if{latex}{\out{\hypertarget{method-transform}{}}}
\subsection{Method \code{transform()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LabelEncoder$transform(data_col)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_col}}{a vector containing non-null values}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Returns the encodings from the fitted model
}

\subsection{Returns}{
encoding values for the given input data
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data_ex <- data.frame(Score = c(10,20,30,4), Name=c('Ao','Bo','Bo','Co'))
lbl <- LabelEncoder$new()
lbl$fit(data_ex$Name)
data_ex$Name <- lbl$transform(data_ex$Name)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-inverse_transform"></a>}}
\if{latex}{\out{\hypertarget{method-inverse_transform}{}}}
\subsection{Method \code{inverse_transform()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LabelEncoder$inverse_transform(coded_col)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{coded_col}}{a vector containing label encoded values}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Gives back the original values from a encoded values
}

\subsection{Returns}{
original values from the label encoded data
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data_ex <- data.frame(Score = c(10,20,30,4), Name=c('Ao','Bo','Bo','Co'))
lbl <- LabelEncoder$new()
lbl$fit(data_ex$Name)
data_ex$Name <- lbl$fit_transform(data_ex$Name)
decode_names <- lbl$inverse_transform(data_ex$Name)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LabelEncoder$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
