% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_diff.R
\name{count_diff}
\alias{count_diff}
\title{Count Difference in Occurrences of Vector Elements}
\usage{
count_diff(vec1, vec2, what = NULL)
}
\arguments{
\item{vec1}{(vector) first vector containing elements to count}

\item{vec2}{(vector) second vector containing elements to count}

\item{what}{(vector) optional argument for what element(s) to count. If left \code{NULL}, defaults to all unique elements found in either vector}
}
\value{
(dataframe) four-column dataframe with as many rows as there are unique elements across both specified vectors or as the number of elements passed to 'what'. First column is named "value" and includes the unique elements of the vector, second and third columns are named "vec1_count" and "vec2_count" respectively and include the number of occurrences of each vector element in each vector. Final column is "diff" and the difference in the count of each element between the first and second input vectors
}
\description{
Counts the number of occurrences of each element in both provided vectors and then calculates the difference in that count between the first and second input vector. Counting of NAs in addition to non-NA values is supported.
}
\examples{
# Define two vectors
x1 <- c(1, 1, NA, "a", 1, "a", NA, "x")
x2 <- c(1, "a", "x")

# Count difference in number of NAs between the two vectors
supportR::count_diff(vec1 = x1, vec2 = x2, what = NA)

# Count difference in all values between the two
supportR::count_diff(vec1 = x1, vec2 = x2)

}
