% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surreal.R
\name{border_augmentation}
\alias{border_augmentation}
\title{Transform Data by Adding a Border}
\usage{
border_augmentation(x, y, n_add_points = 40, verbose = FALSE)
}
\arguments{
\item{x}{Numeric vector of x coordinates.}

\item{y}{Numeric vector of y coordinates.}

\item{n_add_points}{Integer. Number of points to add on each side of the frame. Default is \code{40}.}

\item{verbose}{Logical. If \code{TRUE}, prints optimization progress. Default is \code{FALSE}.}
}
\value{
A matrix with two columns representing the transformed \code{x} and \code{y} coordinates.
}
\description{
This function transforms the input data by adding points around the original data
to create a frame. It uses an optimization process to find the best alpha parameter
for point distribution, which helps in making the fitted values and residuals orthogonal.
}
\examples{
# Simulate data
x <- rnorm(100)
y <- rnorm(100)

# Append border to data
transformed_data <- border_augmentation(x, y)

# Modify par settings for plotting side-by-side
oldpar <- par(mfrow = c(1, 2))

plot(x, y, pch = 16, main = "Original data")
plot(transformed_data[, 1], transformed_data[, 2], pch = 16, main = "Transformed data")

# Restore original par settings
par(oldpar)
}
