% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survSRF_ens.R
\name{survsrfens_cv}
\alias{survsrfens_cv}
\title{Cross-validates predictive performance for SRF Ensemble}
\usage{
survsrfens_cv(
  df,
  predict.factors,
  fixed_time = NaN,
  outer_cv = 3,
  inner_cv = 3,
  repeat_cv = 2,
  randomseed = NaN,
  return_models = FALSE,
  useCoxLasso = FALSE,
  tuningparams = list(),
  max_grid_size = 10,
  verbose = FALSE,
  suppresswarn = TRUE
)
}
\arguments{
\item{df}{data frame with the data, "time" and "event" for survival outcome}

\item{predict.factors}{list of predictor names}

\item{fixed_time}{at which performance metrics are computed}

\item{outer_cv}{number of folds in outer CV, default 3}

\item{inner_cv}{number of folds for model tuning CV, default 3}

\item{repeat_cv}{number of CV repeats, if NaN, runs once}

\item{randomseed}{random seed}

\item{return_models}{TRUE/FALSE, if TRUE returns all trained models}

\item{useCoxLasso}{TRUE/FALSE, default is FALSE}

\item{tuningparams}{if given, list of hyperparameters, list(mtry=c(), nodedepth=c(),nodesize=c()), otherwise a wide default grid is used}

\item{max_grid_size}{number of random grid searches for model tuning}

\item{verbose}{FALSE(default)/TRUE}

\item{suppresswarn}{TRUE/FALSE, TRUE by default}
}
\value{
list of outputs
}
\description{
Cross-validates predictive performance for SRF Ensemble
}
\examples{
\donttest{
\dontshow{rfcores_old <- options()$rf.cores; options(rf.cores=1)}
df <- simulate_nonlinear()
ens_cv <- survsrfens_cv(df, names(df)[1:4])
summary(ens_cv)
\dontshow{options(rf.cores=rfcores_old)}
}
}
