% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_profile.R
\name{predict_profile}
\alias{predict_profile}
\alias{predict_profile.surv_explainer}
\title{Instance Level Profile as Ceteris Paribus for Survival Models}
\usage{
predict_profile(
  explainer,
  new_observation,
  variables = NULL,
  categorical_variables = NULL,
  ...,
  type = "ceteris_paribus",
  variable_splits_type = "uniform"
)

\method{predict_profile}{surv_explainer}(
  explainer,
  new_observation,
  variables = NULL,
  categorical_variables = NULL,
  ...,
  type = "ceteris_paribus",
  output_type = "survival",
  variable_splits_type = "uniform"
)
}
\arguments{
\item{explainer}{an explainer object - model preprocessed by the \code{explain()} function}

\item{new_observation}{a new observation for which the prediction need to be explained}

\item{variables}{a character vector containing names of variables to be explained}

\item{categorical_variables}{a character vector of names of additional variables which should be treated as categorical (factors are automatically treated as categorical variables)}

\item{...}{additional parameters passed to \code{DALEX::predict_profile} if \code{output_type =="risk"}}

\item{type}{character, only \code{"ceteris_paribus"} is implemented}

\item{variable_splits_type}{character, decides how variable grids should be calculated. Use \code{"quantiles"} for percentiles or \code{"uniform"} (default) to get uniform grid of points.}

\item{output_type}{either \code{"survival"} or \code{"risk"} the type of survival model output that should be considered for explanations. If \code{"survival"} the explanations are based on the survival function. Otherwise the scalar risk predictions are used by the \code{DALEX::predict_profile} function.}
}
\value{
An object of class \code{c("predict_profile_survival", "surv_ceteris_paribus")}. It is a list with the final result in the \code{result} element.
}
\description{
This function calculates Ceteris Paribus Proifles for a specific observation with the possibility to take the time dimension into account.
}
\examples{
\donttest{
library(survival)
library(survex)

cph <- coxph(Surv(time, status) ~ ., data = veteran, model = TRUE, x = TRUE, y = TRUE)
rsf_src <- randomForestSRC::rfsrc(Surv(time, status) ~ ., data = veteran)

cph_exp <- explain(cph)
rsf_src_exp <- explain(rsf_src)

cph_predict_profile <- predict_profile(cph_exp, veteran[2, -c(3, 4)],
                                       variables = c("trt", "celltype", "karno", "age"),
                                       categorical_variables = "trt")
plot(cph_predict_profile, facet_ncol = 2)


rsf_predict_profile <- predict_profile(rsf_src_exp, veteran[5, -c(3, 4)], variables = "karno")
plot(cph_predict_profile, numerical_plot_type = "contours")
}

}
