% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_diagnostics.R
\name{model_diagnostics}
\alias{model_diagnostics}
\alias{model_diagnostics.surv_explainer}
\title{Dataset Level Model Diagnostics}
\usage{
model_diagnostics(explainer)

\method{model_diagnostics}{surv_explainer}(explainer)
}
\arguments{
\item{explainer}{an explainer object - model preprocessed by the \code{explain()} function}
}
\value{
An object of class \code{c("model_diagnostics_survival")}. It's a list with the explanations in the \code{result} element.
}
\description{
This function calculates martingale and deviance residuals.
}
\examples{
\donttest{
library(survival)
library(survex)

cph <- coxph(Surv(time, status) ~ ., data = veteran, model = TRUE, x = TRUE, y = TRUE)
rsf_ranger <- ranger::ranger(Surv(time, status) ~ .,
  data = veteran,
  respect.unordered.factors = TRUE,
  num.trees = 100,
  mtry = 3,
  max.depth = 5
)

cph_exp <- explain(cph)

rsf_ranger_exp <- explain(rsf_ranger,
  data = veteran[, -c(3, 4)],
  y = Surv(veteran$time, veteran$status)
)

cph_residuals <- model_diagnostics(cph_exp)
rsf_residuals <- model_diagnostics(rsf_ranger_exp)

head(cph_residuals$result)
plot(cph_residuals, rsf_residuals, xvariable = "age")
plot(cph_residuals, rsf_residuals, plot_type = "Cox-Snell")

}
}
