% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{sd_question}
\alias{sd_question}
\title{Create a survey question}
\usage{
sd_question(
  type,
  id,
  label,
  cols = "80",
  direction = "horizontal",
  status = "default",
  width = "100\%",
  height = NULL,
  selected = NULL,
  label_select = "Choose an option...",
  grid = TRUE,
  individual = TRUE,
  justified = FALSE,
  force_edges = TRUE,
  option = NULL,
  placeholder = NULL,
  resize = NULL,
  row = NULL,
  default = NULL,
  ...
)
}
\arguments{
\item{type}{Specifies the type of question. Possible values are \code{"select"},
\code{"mc"}, \code{"mc_multiple"}, \code{"mc_buttons"}, \code{"mc_multiple_buttons"}, \code{"text"},
\code{"textarea"}, \code{"numeric"}, \code{"slider"}, \code{"slider_numeric"}, \code{"date"},
\code{"daterange"}, and \code{"matrix"}.}

\item{id}{A unique identifier for the question, which will be used as the
variable name in the resulting survey data.}

\item{label}{Character string. The label for the UI element, which can be
formatted with markdown.}

\item{cols}{Integer. Number of columns for the \code{"textarea"} question type.
Defaults to 80.}

\item{direction}{Character string. The direction for button groups
(\code{"horizontal"} or \code{"vertical"}). Defaults to \code{"horizontal"}.}

\item{status}{Character string. The status for button groups.
Defaults to \code{"default"}.}

\item{width}{Character string. The width of the UI element.
Defaults to \code{"100\%"}.}

\item{height}{Character string. The height of the input for the
\code{"textarea"} question type. Defaults to \code{"100px"}.}

\item{selected}{Value. The selected value(s) for certain input elements.}

\item{label_select}{Character string. The label for the select input.
Defaults to \code{"Choose an option..."}.}

\item{grid}{Logical. Whether to show a grid for slider input.
Defaults to \code{TRUE}.}

\item{individual}{Logical. Whether buttons in a group should be individually
styled. Defaults to \code{TRUE}.}

\item{justified}{Logical. Whether buttons in a group should fill the width
of the parent div. Defaults to \code{FALSE}.}

\item{force_edges}{Logical. Whether to force edges for slider input.
Defaults to \code{TRUE}.}

\item{option}{Named vector for the \code{"select"}, \code{"radio"}, \code{"checkbox"},
and \code{"slider"} question types, or numeric vector for \code{"slider_numeric"}
question type.}

\item{placeholder}{Character string. Placeholder text for \code{"text"} and
\code{"textarea"} question types.}

\item{resize}{Character string. Resize option for textarea input.
Defaults to \code{NULL}.}

\item{row}{List. Used for \code{"matrix"} type questions. Contains the row labels
and their corresponding IDs.}

\item{default}{Numeric, length 1 (for a single sided slider), or 2 for a
two sided (range based) slider. Values to be used as the starting default
for the slider. Defaults to the median of values.}

\item{...}{Additional arguments, often specific to different input types.
Examples include \code{pre}, \code{sep}, \code{step}, and \code{animate} for \code{"slider"} and
\code{"slider_numeric"} question types, etc.}
}
\value{
A 'shiny' UI element wrapped in a div with a data attribute for
question ID.
}
\description{
This function creates various types of survey questions for use in a Surveydown survey.
}
\details{
The function supports various question types:
\itemize{
\item \code{"select"}: A dropdown selection
\item \code{"mc"}: Multiple choice (single selection)
\item \code{"mc_multiple"}: Multiple choice (multiple selections allowed)
\item \code{"mc_buttons"}: Multiple choice with button-style options (single selection)
\item \code{"mc_multiple_buttons"}: Multiple choice with button-style options (multiple selections allowed)
\item \code{"text"}: Single-line text question
\item \code{"textarea"}: Multi-line text question
\item \code{"numeric"}: Numeric question
\item \code{"slider"}: Slider question
\item \code{"slider_numeric"}: Extended numeric slider question
\item \code{"date"}: Date question
\item \code{"daterange"}: Date range question
\item \code{"matrix"}: Matrix-style question with rows and columns
}

For \code{"matrix"} type questions, use the \code{row} parameter to define the rows of
the matrix. Each element in the \code{row} list should have a name (used as the
row ID) and a value (used as the row label).
}
\examples{
if (interactive()) {
  library(surveydown)

  # Get path to example survey file
  survey_path <- system.file("examples", "basic_survey.qmd",
                             package = "surveydown")

  # Copy to a temporary directory
  temp_dir <- tempdir()
  file.copy(survey_path, file.path(temp_dir, "survey.qmd"))
  orig_dir <- getwd()
  setwd(temp_dir)

  # Define a minimal server
  server <- function(input, output, session) {
    sd_server()
  }

  # Run the app
  shiny::shinyApp(ui = sd_ui(), server = server)

  # Clean up
  setwd(orig_dir)
}

}
